% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explode.R
\name{explode}
\alias{explode}
\title{Explodes multipart features}
\usage{
explode(x, sp = FALSE)
}
\arguments{
\item{x}{sp or sf multipart (MULTIPOLYGON, MULTIPOINT, MULTILINE) object}

\item{sp}{(FALSE/TRUE) output as sp class object, else is sf class}
}
\value{
A single part sp or sf object (polygons or points)
}
\description{
Explodes multipart features into single part
}
\note{
Multipart geometries are a data structure where a single attribute shares multiple 
features (polygons, points, lines). This function dissaggregates the data into a 
one-to-one match.
}
\examples{
\dontrun{
library(sf)
library(sp)

dim( p.sf <- st_read(system.file("shapes/sids.shp", package = "spData")[1]) )
dim( p.sf <- explode(p.sf) )
}

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
