% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyPerimeter.R
\name{polyPerimeter}
\alias{polyPerimeter}
\title{Polygon perimeter}
\usage{
polyPerimeter(x)
}
\arguments{
\item{x}{sp class SpatialPolygonsDataFrame object}
}
\value{
A vector of polygon perimeters
}
\description{
Calculates the perimeter length(s) for a polygon object
}
\examples{
library(sp)
p1 <- Polygons(list(Polygon(cbind(c(2,4,4,1,2),c(2,3,5,4,2)))), "1")
p2 <- Polygons(list(Polygon(cbind(c(5,4,2,5),c(2,3,2,2)))), "2")
p3 <- Polygons(list(Polygon(cbind(c(4,4,5,10,4),c(5,3,2,5,5)))),"3")
polys <- SpatialPolygons(list(p1,p2,p3), 1:3)

polyPerimeter(polys)

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
