% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_angle.R
\name{mean_angle}
\alias{mean_angle}
\title{Mean Angle}
\usage{
mean_angle(a, angle = c("degree", "radians"))
}
\arguments{
\item{a}{vector of angle values}

\item{angle}{("degree", "radians") to define angle in degrees or radians}
}
\value{
A vector of mean angle
}
\description{
Calculates the mean angle of a vector
}
\note{
The arithmetic mean is not correct for calculating the central tendency of
angles. This function is intended to return the mean angle for slope or aspect,
which could be used in a focal or zonal function.
}
\examples{
mean_angle(c(180, 10))
  mean(c(180, 10))
mean_angle(c(90, 180, 70, 60))
  mean(c(90, 180, 70, 60))
mean_angle(c(90, 180, 270, 360))
  mean(c(90, 180, 270, 360))

library(terra)
elev <- rast(system.file("extdata/elev.tif", package="spatialEco"))
asp <- terrain(elev, v="aspect")
s <- buffer(spatSample(asp, 20, as.points=TRUE, 
            na.rm=TRUE, values=FALSE), 5000)

plot(asp)
  plot(s, add=TRUE)

d <- extract(asp, s)
cat("Mean angles of aspect", "\n")
  tapply(d[,2], d[,1], mean_angle) 
cat("arithmetic means of aspect", "\n")
  tapply(d[,2], d[,1], mean, na.rm=TRUE) 

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
