% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexagons.R
\name{hexagons}
\alias{hexagons}
\title{Hexagons}
\usage{
hexagons(x, res = 100, ...)
}
\arguments{
\item{x}{sp SpatialDataFrame class object}

\item{res}{Area of resulting hexagons}

\item{...}{Additional arguments passed to spsample}
}
\value{
SpatialPolygonsDataFrame OBJECT
}
\description{
Create hexagon polygons
}
\note{
depends: sp
}
\examples{
 library(sf)
 if(require(sp, quietly = TRUE)) {
   data(meuse, package = "sp")
   meuse <- st_as_sf(meuse, coords = c("x", "y"), crs = 28992, 
                     agr = "constant")

hex <- hexagons(meuse, res=300)   
  plot(st_geometry(hex))
    plot(st_geometry(meuse),pch=20,add=TRUE)

# subset hexagons to intersection with points
idx <- which(apply(st_intersects(hex, meuse, sparse=FALSE), 1, any))
hex.sub <- hex[idx,] 
  plot(st_geometry(hex.sub))
    plot(st_geometry(meuse),pch=20,add=TRUE)
}
}
