% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal.k.R
\name{optimal.k}
\alias{optimal.k}
\title{optimalK}
\usage{
optimal.k(x, nk = 10, plot = TRUE, cluster = TRUE, clara = FALSE, ...)
}
\arguments{
\item{x}{Numeric dataframe, matrix or vector}

\item{nk}{Number of clusters to test (2:nk)}

\item{plot}{(TRUE / FALSE) Plot cluster silhouettes(TRUE/FALSE)}

\item{cluster}{(TRUE / FALSE) Create cluster object with optimal k}

\item{clara}{(FALSE / TRUE) Use clara model for large data}

\item{...}{Additional arguments passed to clara}
}
\value{
Object of class clust "pam" or "clara" with tested silhouette values
}
\description{
Find optimal k of k-Medoid partitions using 
             silhouette widths
}
\examples{
library(cluster)
  x <- rbind(cbind(rnorm(10,0,0.5), rnorm(10,0,0.5)),
             cbind(rnorm(15,5,0.5), rnorm(15,5,0.5)))

  clust <- optimal.k(x, 20, plot=TRUE, cluster=TRUE)
    plot(silhouette(clust$model), col = c('red', 'green'))
      plot(clust$model, which.plots=1, main='K-Medoid fit')

# Extract multivariate and univariate mediods (class centers)
  clust$model$medoids
    pam(x[,1], 1)$medoids  

# join clusters to data
  x <- data.frame(x, k=clust$model$clustering) 

}
\references{
Theodoridis, S. & K. Koutroumbas(2006) Pattern Recognition 3rd ed.
}
\seealso{
\code{\link[cluster]{pam}} for details on Partitioning Around Medoids (PAM)

\code{\link[cluster]{clara}} for details on Clustering Large Applications (clara)
}
\author{
Jeffrey S. Evans  <jeffrey_evans<at>tnc.org>
}
