% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random.raster.R
\name{random.raster}
\alias{random.raster}
\title{Random raster}
\usage{
random.raster(
  r = NULL,
  n.row = 50,
  n.col = 50,
  n.layers = 1,
  x = seq(1, 10),
  min = 0,
  max = 1,
  mean = 0,
  sd = 1,
  p = 0.5,
  s = 1.5,
  mask = TRUE,
  distribution = c("random", "normal", "seq", "binominal", "gaussian")
)
}
\arguments{
\item{r}{Optional existing terra raster defining nrow/ncol}

\item{n.row}{Number of rows}

\item{n.col}{Number of columns}

\item{n.layers}{Number of layers in resulting raster stack}

\item{x}{A vector of values to sample if distribution is "sample"}

\item{min}{Minimum value of raster}

\item{max}{Maximum value of raster}

\item{mean}{Mean of centered distribution}

\item{sd}{Standard deviation of centered distribution}

\item{p}{p-value for binominal distribution}

\item{s}{sigma value for Gaussian distribution}

\item{mask}{(TRUE/FALSE) If r is provided, mask results to r}

\item{distribution}{Available distributions, c("random", "normal", 
"seq", "binominal", "gaussian", "sample")}
}
\value{
terra SpatRaster object with random rasters
}
\description{
Create a random raster or raster stack using specified 
             distribution
}
\details{
Options for distributions are for random, normal, seq, binominal, 
gaussian and sample raster(s)
}
\examples{
library(terra)

# Using existing raster to create random binominal  
r <- rast(system.file("ex/elev.tif", package="terra"))    
( rr <- random.raster(r, n.layers = 3, distribution="binominal") )
  plot(c(r,rr)) 

# default; random, nrows=50, ncols=50, n.layers=5
( rr <- random.raster() )

# specified; binominal, nrows=20, ncols=20, nlayers=5
( rr <- random.raster(n.layer=5, n.col=20, n.row=20,  
                     distribution="binominal") )

# specified; gaussian, nrows=50, ncols=50, nlayers=1
( rr <- random.raster(n.col=50, n.row=50, s=8,  
                      distribution="gaussian") )
   plot(rr)
 
# specified; sample, nrows=50, ncols=50, nlayers=1
( rr <- random.raster(n.layer=1, x=c(2,6,10,15), 
                     distribution="sample" ) )
  freq(rr)

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
