% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{pca}
\alias{pca}
\title{Principal Components Analysis}
\usage{
pca(
  x = NULL,
  colnames.prefix = "pca_factor"
)
}
\arguments{
\item{x}{numeric matrix or data frame, Default: NULL}

\item{colnames.prefix}{character, name prefix for the output columns, Default: 'pca_factor'}
}
\value{
A data frame with the PCA factors of \code{x}.
}
\description{
Extracts all factors of a principal component analysis of a matrix or data frame. Just a convenient wrapper for \link{prcomp}.
}
\details{
Columns in \code{x} with zero variance are removed before computing the PCA.
}
\examples{
if(interactive()){

 #load example distance matrix
 data(distance_matrix)

 #PCA of the distance matrix
 out <- pca(x = distance_matrix)
 out

}
}
\seealso{
\code{\link[=pca_multithreshold]{pca_multithreshold()}}
}
