% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concentration.R
\name{concentration}
\alias{concentration}
\title{Concentration risk}
\usage{
concentration(
  sub,
  full,
  value,
  lon_sub = lon,
  lat_sub = lat,
  lon_full = lon,
  lat_full = lat,
  radius = 200,
  display_progress = TRUE
)
}
\arguments{
\item{sub}{data.frame of locations to calculate concentration risk for (target points). \code{sub} should include at least
columns for longitude and latitude.}

\item{full}{data.frame to find the locations within radius \code{r} from locations in \code{sub} (reference locations). \code{full}
should include at least columns for longitude, latitude and value of interest to summarize.}

\item{value}{column name with value of interest to summarize in \code{full}.}

\item{lon_sub}{column name in \code{sub} with longitude (lon is default).}

\item{lat_sub}{column name in \code{sub} with latitude (lat is default).}

\item{lon_full}{column name in \code{full} with longitude in \code{full} (lon is default).}

\item{lat_full}{column name in \code{full} with latitude in \code{full} (lat is default).}

\item{radius}{radius (in meters) (default is 200m).}

\item{display_progress}{show progress bar (TRUE/FALSE). Defaults to TRUE.}
}
\value{
A data.frame equal to data.frame \code{sub} including an extra column \code{concentration}.
}
\description{
The sum of all observations within a circle of a certain radius.
}
\details{
A recently European Commission regulation requires insurance companies to determine the maximum value of insured fire
risk policies of all buildings that are partly or fully located within circle of a radius of 200m
(Commission Delegated Regulation (EU), 2015, Article 132). The problem can be stated as: "find the centre coordinates of a circle
with a fixed radius that maximizes the coverage of total fire risk insured". This can be viewed as a particular instance
of the Maximal Covering Location Problem (MCLP) with fixed radius. The computational performance of \code{concentration()} is
investigated to overcome the long times the MCLP algorithm is taking. \code{concentration()} is written in C++, and for 500,000 buildings it
needs about five minutes to determine the value of insured fire risk policies that are partly or fully located within
circle of a radius of 200m.
}
\examples{
df <- data.frame(location = c("p1", "p2"), lon = c(6.561561, 6.561398), lat = c(53.21369, 53.21326))
concentration(df, Groningen, value = amount, radius = 100)

}
\references{
Commission Delegated Regulation (EU) (2015). Solvency II Delegated Act 2015/35. Official Journal of the European Union, 58:124.
}
\author{
Martin Haringa
}
