% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isar.R
\name{isarF}
\alias{isarF}
\alias{isar.index}
\title{Individual Species Area Relationship}
\usage{
isarF(X, r = NULL, target = NULL, v2 = FALSE, v3 = FALSE,
  v4 = FALSE, ...)

isar.index(X, r = 4, ntype = "knn", ...)
}
\arguments{
\item{X}{Multitype point pattern of class \code{ppp} (see package 'spatstat')}

\item{r}{Vector of sizes for neighbourhoods, e.g. \code{geometric} graph with
different ranges.}

\item{target}{Default NULL. Calculate only for target type. If NULL computes
for each type + mean over all types.}

\item{v2}{Logical. Estimate species-to-neighbours-ratio instead of just total
number of species.}

\item{v3}{Logical. Instead of summing number 1 for each species present, sum
the average X$mass of each species present.}

\item{v4}{Logical. Estimate ISAR using empty space probabilities instead of
direct counts (equals the normal version in all my tests)}

\item{...}{Further parameters for the function \code{segregationFun}.}

\item{ntype}{Sets the n'hood type to \code{knn} by default in isar.index.}
}
\description{
Compute the Individual Species Area Relationship ( ISAR ) or Local Species
Richness, for a given multitype point pattern.
}
\details{
Extension of ISAR-function introduced in WGGH07. In effect
calculates the expected amount of different types present in the
neighbourhood of a point in the pattern.

The function \code{isarF} is the calculation function for different
neighbourhoods. Uses function \code{\link{segregationFun}}.

The function \code{isar.index} is a shortcut to get a single value for the
pattern. Uses 4-nn graph by default.
}
\section{Functions}{
\itemize{
\item \code{isar.index}: Shortcut for 4-nearest neighbour value.
}}

\references{
Rajala, Illian: A family of spatial biodiversity measures based on graphs, Env. Ecol. Stat. 2012

Wiegand, Gunatilleke, Gunatilleke, Huth: How individual species structure diversity in tropical forests. PNAS, nov 16, 2007.
}
