% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/task_patch_indic_methods.R
\name{patchdistr_spews_predict}
\alias{patchdistr_spews_predict}
\alias{predict.patchdistr_spews_single}
\title{predict method for patchdistr_spews objects}
\usage{
\method{predict}{patchdistr_spews_single}(object, ..., newdata = NULL,
  best_only = FALSE)
}
\arguments{
\item{object}{An \code{\link{patchdistr_spews}} object}

\item{...}{Ignored additionnal arguments}

\item{newdata}{A vector of patch sizes at which the fit is returned (default 
to 200 regularly-spaced values).}

\item{best_only}{Return values for only the best fit of each element (matrix)
in \code{object}, or return the values for all fitted distribution.}
}
\value{
A list with component obs, a data.frame containing the observed 
  distribution values and pred, a data.frame containing the fitted 
  values.
}
\description{
Export the observed and fitted patch size distributions
}
\details{
The function \code{\link{patchdistr_spews}} fits competing 
  distribution models to the observed patch size distributions. This 
  functions is able to export the observed values and the fitted values 
  altogether.
}
\examples{

\dontrun{ 
patch_indics <- patchdistr_spews(forestgap)

predict(patch_indics)

}

}
\seealso{
\code{\link{patchdistr_spews}}, 
  \code{\link[=patchdistr_spews_plot]{plot}}, 
  \code{\link[=patchdistr_spews_plot]{plot_distr}},
}
