# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

coarse_grain_cpp <- function(mat, subsize) {
    .Call('_spatialwarnings_coarse_grain_cpp', PACKAGE = 'spatialwarnings', mat, subsize)
}

discpowerexp_norm <- function(expo, rate, xmin) {
    .Call('_spatialwarnings_discpowerexp_norm', PACKAGE = 'spatialwarnings', expo, rate, xmin)
}

fl_internal <- function(m) {
    .Call('_spatialwarnings_fl_internal', PACKAGE = 'spatialwarnings', m)
}

label_cpp <- function(mat, nbmask, wrap) {
    .Call('_spatialwarnings_label_cpp', PACKAGE = 'spatialwarnings', mat, nbmask, wrap)
}

#' 
#' @title Spatial correlation at lag 1
#'
#' @description This function computes the Moran's I index of spatial 
#'   correlation at lag 1.
#' 
#' @param mat A matrix
#' 
#' @return The Moran's I numeric value as a numeric number.
#' 
#' @details This function returns the spatial correlation as measured by 
#'   the Moran's I index. If the variance of the matrix is zero, then 
#'   \code{NaN} is returned. 
#' 
#' @seealso \code{\link{indicator_moran}}, \code{\link{generic_sews}} 
#' 
#' @examples
#' 
#' # Spatial correlation of white noise is close to zero
#' rmat <- matrix(runif(1000) > .5, ncol = 100)
#' raw_moran(rmat) 
#' 
#'@export
raw_moran <- function(mat) {
    .Call('_spatialwarnings_raw_moran', PACKAGE = 'spatialwarnings', mat)
}

tplsum <- function(expo, rate, xs, xmin) {
    .Call('_spatialwarnings_tplsum', PACKAGE = 'spatialwarnings', expo, rate, xs, xmin)
}

tplinfsum <- function(expo, rate, xmin) {
    .Call('_spatialwarnings_tplinfsum', PACKAGE = 'spatialwarnings', expo, rate, xmin)
}

lerchphi <- function(z, s, v) {
    .Call('_spatialwarnings_lerchphi', PACKAGE = 'spatialwarnings', z, s, v)
}

shuffle_matrix <- function(mat) {
    .Call('_spatialwarnings_shuffle_matrix', PACKAGE = 'spatialwarnings', mat)
}

shuffle_and_compute <- function(mat, indic, nrep) {
    .Call('_spatialwarnings_shuffle_and_compute', PACKAGE = 'spatialwarnings', mat, indic, nrep)
}

#' @title r-spectrum 
#' 
#' @description Compute the r-spectrum of a matrix 
#' 
#' @param mat A matrix with logical or numeric values 
#' 
#' @return A data.frame with two columns: \code{dist}, the wave number and 
#'   \code{rspec}, the normalized value of the r-spectrum
#' 
#' @details This functions returns a data.frame with \code{NA}s in the rspec 
#'   column if the input matrix has zero variance. Note that if the matrix 
#'   is not square, then only the largest square matrix fitting in the upper 
#'   right corner is used. 
#' 
#' @seealso \code{\link{spectral_sews}}
#' 
#' @examples 
#' 
#' # Spectrum of white noise
#' rmat <- matrix(runif(100*100) > .5, ncol = 100)
#' spec <- rspectrum(rmat) 
#' plot(spec, type = "l")
#' 
#' # Add some spatial correlation and compare the two spectra
#' rmat.cor <- rmat
#' for (i in seq(1, nrow(rmat)-1)) { 
#'   for (j in seq(1, nrow(rmat)-1)) { 
#'     rmat.cor[i,j] <- mean(rmat[(i-1):(i+1), (j-1):(j+1)])
#'   }
#' }
#' spec.cor <- rspectrum(rmat.cor)
#' plot(spec.cor, type = "n")
#' lines(spec, col = "black")
#' lines(spec.cor, col = "blue")
#' 
#' @export
rspectrum <- function(mat) {
    .Call('_spatialwarnings_rspectrum', PACKAGE = 'spatialwarnings', mat)
}

cpp_skewness <- function(X) {
    .Call('_spatialwarnings_cpp_skewness', PACKAGE = 'spatialwarnings', X)
}

sum_all_one_over_k <- function(from, to, expo) {
    .Call('_spatialwarnings_sum_all_one_over_k', PACKAGE = 'spatialwarnings', from, to, expo)
}

sum_all_one_over_k_before <- function(n, expo) {
    .Call('_spatialwarnings_sum_all_one_over_k_before', PACKAGE = 'spatialwarnings', n, expo)
}

