% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/task_patch_indic_methods.R
\name{patchdistr_sews_plot}
\alias{patchdistr_sews_plot}
\alias{plot.patchdistr_sews}
\alias{plot_distr}
\title{Early-warning signals based on patch size distributions}
\usage{
\method{plot}{patchdistr_sews}(x, along = NULL, ...)

plot_distr(x, along = NULL, best_only = TRUE, plrange = TRUE)
}
\arguments{
\item{x}{An object as produced by \code{\link{patchdistr_sews}}, or 
the result of \code{\link{indictest}} called on such object}

\item{along}{A vector providing values along which the indicator trends 
will be plotted. If \code{NULL} then the values are plotted sequentially 
in their original order.}

\item{...}{Ignored}

\item{best_only}{Plot only the best fit the empirical (inverse cumulative) 
patch-size distribution with an overlay of the estimated fits.}

\item{plrange}{Plot the power-law range}
}
\description{
Plot early-warning signals based on patch size distributions
}
\details{
The \code{plot} function will produce a figure summarizing the changes
  in patch size distributions along a set of values. The figure has two 
  panels: 
  \itemize{ 
     \item the upper panel shows the percolation status of empty 
       (\code{FALSE}) and occupied cells (\code{TRUE}), and shows the mean 
       value (proportion of \code{TRUE} values). The background shows 
       the proportion of each type of distribution for each unique values 
       of the \code{along} vector. 
       
     \item the bottom panel displays the power-law range
  }
 
 The \code{plot_distr} function displays each distribution in an 
   individual facet, with an overlay of the best distribution fit and a blue 
   bar showing the power-law range. If appropriate, a grey ribbon is used to
   display the expected distribution given the null expectation (i.e. when 
   \code{plot_distr} is called on the results of \code{indictest()}. This 
   function can produce quite crowded graphs, but it displays in full the
   shape of the distributions, and can be useful e.g. to assess the quality 
   of the fits.
}
\examples{

\dontrun{ 
data(forestgap)
psd_indic <- patchdistr_sews(forestgap)

plot(psd_indic, along = forestgap.pars[ ,"d"]) 

# When along is non-numeric, bars are used for display
plot(psd_indic, along = as.factor(forestgap.pars[ ,"d"]))

# Display individual distributions
plot_distr(psd_indic, along = forestgap.pars[ ,"d"])

# We can display the distributions along with the null expectation after 
# indictest() is run
psd_test <- indictest(psd_indic, nulln = 19)
plot_distr(psd_test, along = forestgap.pars[ ,"d"])
}

}
\seealso{
\code{\link{patchdistr_sews}}
}
