\name{anova.ppm}
\alias{anova.ppm}
\title{ANOVA for Fitted Point Process Models}
\description{
Performs analysis of deviance for two or more fitted point process models.
}
\usage{
  \method{anova}{ppm}(object, \dots, test=NULL, override=FALSE)
}
\arguments{
  \item{object}{A fitted point process model
    (object of class \code{"ppm"}).
    }
    \item{\dots}{
      One or more fitted point process models.
    }
    \item{test}{
      Character string, partially matching one of
      \code{"Chisq"}, \code{"F"} or \code{"Cp"}.
    }
    \item{override}{
      Logical flag indicating whether to proceed even when there is
      no statistical theory to support the calculation.
    }
}
\value{
  An object of class \code{"anova"}, or \code{NULL}.
}
\details{
  This is a method for \code{\link{anova}} for 
  fitted point process models (objects of class \code{"ppm"},
  usually generated by the model-fitting function \code{\link{ppm}}).

  If the fitted models are all Poisson point processes,
  then this function performs an Analysis of Deviance of
  the fitted models. The output shows the deviance differences
  (i.e. 2 times log likelihood ratio),
  the difference in degrees of freedom, and (if \code{test="Chi"})
  the two-sided p-values for the chi-squared tests. Their interpretation
  is very similar to that in \code{\link{anova.glm}}.

  If some of the fitted models are \emph{not} Poisson point processes,
  then there is no statistical theory available to support
  a similar analysis. The function issues a warning,
  and (by default) returns a \code{NULL} value.

  However if \code{override=TRUE},
  then a kind of analysis of deviance table will be printed.
  The `deviance' differences in this table are equal to 2 times the differences
  in the maximised values of the log pseudolikelihood (see
  \code{\link{ppm}}). At the time of writing, there is no statistical
  theory to support inferential interpretation of log pseudolikelihood
  ratios. The \code{override} option is provided for research purposes
  only!
}
\section{Errors and warnings}{
  \describe{
    \item{models not nested:}{
      There may be an error message that the models are not \dQuote{nested}.
      For an Analysis of Deviance the models must be nested, i.e. one model
      must be a special case of the other. For example the point process
      model with formula \code{~x} is a special case of the model with
      formula \code{~x+y}, so these models are nested. However
      the two point process
      models with formulae \code{~x} and \code{~y} are not nested.
      
      If you get this error message and you believe that the models should
      be nested, the problem may be the inability of \R to recognise that
      the two formulae are nested. Try modifying the formulae to make
      their relationship more obvious.
    }
    \item{different sizes of dataset:}{
      There may be an error message from \code{anova.glmlist} that
      \dQuote{models were not all fitted to the same size of dataset}.
      This implies that the models were fitted using different
      quadrature schemes (see \code{\link{quadscheme}}) and/or
      with different edge corrections or different values of the
      border edge correction distance \code{rbord}.

      To ensure that models are comparable, check the following:
      \itemize{
	\item the models must all have been fitted to the same
	point pattern dataset, in the same window.
	\item all models must have been fitted by the same
	fitting method as specified by the argument \code{method} in
	\code{\link{ppm}}. 
	\item If some of the models depend on covariates, then
	they should all have been fitted using the same list of
	covariates, and using \code{allcovar=TRUE} to ensure that the
	same quadrature scheme is used.
	\item all models must have been fitted using the same edge
	correction as specified by the arguments \code{correction}
	and \code{rbord}. If you did not specify the value of
	\code{rbord}, then it may have
	taken a different value for different models. The default value of
	\code{rbord} is equal to zero for a Poisson model,
	and otherwise equals the reach (interaction distance) of the
	interaction term (see \code{\link{reach}}).
	To ensure that the models are comparable, set \code{rbord} to
	equal the maximum reach of the interactions that you
	are fitting.
      }
    }
  }
}
\seealso{
  \code{\link{ppm}}
}
\examples{
 data(swedishpines)
 mod0 <- ppm(swedishpines, ~1, Poisson())
 modx <- ppm(swedishpines, ~x, Poisson())
 anova(mod0, modx, test="Chi")
}
\author{Adrian Baddeley
  \email{Adrian.Baddeley@csiro.au}
  \url{http://www.maths.uwa.edu.au/~adrian/}
  and Rolf Turner
  \email{r.turner@auckland.ac.nz}
}
\keyword{spatial}
\keyword{models}
\keyword{methods}
 
 
