% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterOnDistance.R
\name{filterOnDistance}
\alias{filterOnDistance}
\title{Filter sample using a minimum distance.}
\usage{
filterOnDistance(overSample, minRadius)
}
\arguments{
\item{overSample}{A HIP sample.}

\item{minRadius}{The minimum distance between any two points in the sample.}
}
\value{
S The set of points that are more than minRadius from each other.
}
\description{
The input parameter minRadius >= 0 is the minimum distance between any two
points in the sample. My idea is to apply this condition to the points in the over-sample,
result$overSample. Let's call these points x1, x2, ..., xB. Create a new set S = (x1).
Starting from x1, we check if dist(S,x2) > minRadius. If it is, add x2 to S. For x3, we check
if dist(S,x3) > minRadius, where dist is the smallest distance from a point in S to x3
(single linkage distance). If dist(S,x3) > minRadius, add x3 to S. Continue until you reach xB.

The distances are calculated as great circles over an oblate spheroid and the units are meters.
}
\details{
Key points:

\itemize{
\item \code{result$minRadius} is nonempty (it always contains x1). Hence, if the user chooses a crazy minRadius, they get one point.
\item \code{result$minRadius} is a subset of result$overSample.
\item The number of points in result$minRadius is random. That's fine!
\item If they want n points and result$minRadius has less than n, too bad! They can reduce minRadius and/or increase the iterations parameter.
\item If they want a sample with the minimum radius property, they use:
\itemize{
\item \code{smp <- result$minRadius}
\item \code{sample <- smp[1:n,]}
}
}
}
\author{
Phil Davies.
}
\keyword{internal}
