% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SPCA_B&B_all_Funcs.R
\name{spcabb}
\alias{spcabb}
\title{SPCA by Branch-and-Bound}
\usage{
spcabb(S, card, unc = TRUE, startind, excludeload = FALSE, nvexp = FALSE,
  msg = TRUE)
}
\arguments{
\item{S}{A correlation or covariance matrix.}

\item{card}{A vector of cardinalities for each component. the number of
dimensions to compute is determined from its length.}

\item{unc}{A logical vector indicating if each component should be should be
uncorrelated to the preceeding ones or not.}

\item{startind}{A list of indices from which the sparse loadings will be
computed. If missing all combinations of indices are searched.}

\item{excludeload}{Logical: vector (length nd or shorter) should indices of
non-zero loadings in previous components be excluded from future searches?}

\item{nvexp}{Logical. If TRUE the real variance estimated is used as
objective function. Otherwise an approximated form of the variance
explainedis used.}

\item{msg}{Logical: should messages be printed after each component is
computed}
}
\value{
An object of class \emph{spca} is returned. It contains:
\item{loadings}{The matrix of loadings} \item{vexp}{A vector of variances
explained by each component} \item{vexpPC}{A vector of variances explained
by each PC} \item{ind}{A list containing the indices of the non-sparse
loadings} \item{niter}{Number of iterations to compute each component} Call
arguments \item{unc}{the argument unc passed} \item{nvexp}{The argument
nvexp passed} If \code{any unc[j] = FALSE} \item{corComp}{Matrix with
correlations among components.} \item{Aunc}{Loadings of components made
uncorrelated.}
}
\description{
Finds the LS SPCA loadings with given cardinalities using Branch-and-Bound
}
\details{
If unc = FALSE, when nvexp = TRUE the objective function is the true
variance explained, otherwise the approximated one (see references or Vignettes for details). unc and excludeload can
be vectors of length less than nd (hence also a single value), in this case,
the last element is assigned to the missing ones. The BB search is
computationally demanding, for large problems (n > 50) consider using
\code{\link{spcabe}} Just in case the functions takes too long and it is
interrupted, a minimal output of the loadings computed is returned.
This is a minimal spca
object with elements A, the loadings so far computed, vexp and vexpv.
}
\note{
Thanks to Dr Alessio Farcomeni for making avilable his R code for the
BB algorithm. This version is a slight variation of it.
}
\examples{
\dontrun{
data(anthrop)
## 3 uncorrelated components with sparse loadings each of cardinality
## 3, 3 and 2 (the last value will be set to 3 because uncorrelated components
## must have cardinality at least equal to their order)
myspca1 <- spcabb(anthrop, card = c(3,3, 2) )
# print the results
myspca1
# print summary results
summary(myspca1)
# show how many iterations each compnent took
myspca1$niter
# plot loadings and cumulative variance explained (4 plots)
plot(myspca1, plotload = TRUE, onlynonzero = FALSE, variablesnames = TRUE)

## 3 correlated components with sparse loadings also each of cardinality 3
myspca2 <- spcabb(anthrop, card = rep(3, 3), unc = FALSE, nvexp = FALSE )
# print results
myspca2
# print summary results
summary(myspca2)
# show how many iterations each compnent took
myspca2$niter
## compare the correlated with the uncorrelated solutions
compare(myspca1, myspca2, methodsnames = c("unc", "cor"))
# print the correlations among the correlated components
myspca2$corComp
# print the loadings of components made uncorrelated
myspca2$loadingsUnc

## 3 correlated components with sparse loadings of cardinality 2, 1 and 3
myspca3 <- spcabb(anthrop, card = c(2, 1, 1), unc = FALSE )
# print the results
myspca3
# print summary results
summary(myspca3)
## print correlation between components
myspca3$corComp
## print loadings of components made uncorrelated
myspca3$loadingsUnc
   }
}
\author{
Giovanni Merola
}
\seealso{
\code{\link{spcabe}}
}
\keyword{spca}

