% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap.R
\name{setup}
\alias{setup}
\alias{drop}
\alias{set_pattern}
\alias{set_level}
\alias{trace}
\alias{debug}
\alias{info}
\alias{warn}
\alias{error}
\alias{critical}
\alias{fmt}
\alias{cat}
\title{Convenience Wrappers for 'RcppSpdlog' Logging From 'spdlog'}
\usage{
setup(name = "default", level = "warn")

drop(s)

set_pattern(s)

set_level(s)

trace(s, ...)

debug(s, ...)

info(s, ...)

warn(s, ...)

error(s, ...)

critical(s, ...)

fmt(s, ...)

cat(...)
}
\arguments{
\item{name}{Character value for the name of the logger instance}

\item{level}{Character value for the logging level}

\item{s}{Character value for pattern, level, or logging message}

\item{...}{Supplementary arguments for the logging string}
}
\value{
Nothing is returned from these functions as they are invoked for their side-effects.
}
\description{
Several short wrappers for functions from 'RcppSpdlog' package are provided
as a convenience.  Given the potential for clashing names of common and popular
functions names we do \emph{not} recommend the import the whole package but rather
do \code{importFrom(RcppSpdlog, set_pattern)} (or maybe \code{importFrom(RcppSpdlog,
set_pattern)}). After that, functionality can be accessed via a convenient shorter
form such as for example \code{spdl::info()} to log at the \sQuote{info} level.
Format strings suitable for the C++ library \sQuote{fmtlib::fmt} and its
\code{fmt::format()} (which as of C++20 becomes \sQuote{std::fmt}) are supported
so the \code{\{\}} is the placeholder for simple (scalar) arguments (for which the
default R formatter is called before passing on a character representation).
}
\examples{
spdl::setup("exampleDemo", "warn")
spdl::info("Not seen as level 'info' below 'warn'")
spdl::warn("This warning message is seen")
spdl::set_level("info")
spdl::info("Now this informational message is seen too")
spdl::info("Calls use fmtlib::fmt {} as we can see {}", "under the hood", 42L)
}
