% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtable.spdur.R
\name{xtable.spdur}
\alias{xtable.spdur}
\title{Create export table for a split-duration model}
\usage{
\method{xtable}{spdur}(x, ...)
}
\arguments{
\item{x}{An object with class \code{spdur}.}

\item{\dots}{Further arguments passed to \code{\link[xtable]{xtable}}.}
}
\value{
An object with class \code{xtable}.
}
\description{
\code{xtable}-like function for class ``\code{spdur}''.
}
\details{
Format a split-duration model for export to Latex or html.
}
\examples{
library(xtable)
data(model.coups)
xtable(model.coups)
print(xtable(model.coups), include.rownames=FALSE)

}
\seealso{
\code{\link{xtable}}, or \code{\link{as.data.frame.spdur}} for a
  simpler alternative that will convert a \code{spdur} object to a data frame
  containing model parameter estimates.

For print formatting, see \code{\link{print.xtable}}.
}

