% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PeakGrouper.R
\name{PeakGrouper}
\alias{PeakGrouper}
\title{Peak grouping with hierarchical clustering}
\usage{
PeakGrouper(Y.peaks, grouping.window.width = 100, verbose = FALSE,
  min.samp.grp = 1, max.dupli.prop = 0.25, maxClust = 10,
  Jaccard.regroup.threshold = 0.25, linkage = "average")
}
\arguments{
\item{Y.peaks}{data frame obtained from the 'getWaveletPeaks' function.}

\item{grouping.window.width}{The width of the sliding window (in measurement points). Measurements are taken for when this sliding window is taken too small, but best set this too a value that a normal peak is comfortably in a window. Note if large shifts occur in your dataset (like in the wine dataset) it is best to set this parameter larger.}

\item{verbose}{If set to TRUE the window selection process is documented in real time (default = FALSE).}

\item{min.samp.grp}{The minimal amount of samples needed to form a group, see \link[speaq]{hclust.grouping}.}

\item{max.dupli.prop}{The maximal duplication proportion allowed for a group to be considered a single group, see \link[speaq]{hclust.grouping}.}

\item{maxClust}{The maximum number of clusters (depth of the tree), see \link[speaq]{hclust.grouping}.}

\item{Jaccard.regroup.threshold}{If 2 neighbouring groups have a jaccard index smaller than this 'Jaccard.regroup.threshold' (indicating that they are quite complementary as they have little peaks samples in common), then they are merged and regrouped. This situation can occur if a group is accidentally cut in half by the window approach.}

\item{linkage}{The linkage to be used in the hierarchical clustering. See the 'method' argument in \link[stats]{hclust}.}
}
\value{
Returns a data frame with grouped peaks. Peaks in a group are indicated with an identical peakIndex
}
\description{
This functions groups the peaks obtained after wavelet based peak detection (with the 'getWaveletPeaks' function).
}
\examples{
subset <- GetWinedata.subset()
subset.spectra = as.matrix(subset$Spectra)
subset.ppm = as.numeric(subset$PPM)

test.peaks <- getWaveletPeaks(Y.spec=subset.spectra, 
                              X.ppm=subset.ppm ,
                              nCPU = 2) # nCPU set to 2 for the vignette build

test.grouped <- PeakGrouper(Y.peaks = test.peaks)

}
\seealso{
\code{\link{hclust.grouping}}
}
\author{
Charlie Beirnaert, \email{charlie.beirnaert@uantwerpen.be}
}
