% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BuildRawDataMatrix.R
\name{BuildRawDataMatrix}
\alias{BuildRawDataMatrix}
\title{Build a raw data matrix (spectra) from spectra of unequal length}
\usage{
BuildRawDataMatrix(spectrum.list, ppm.list = NULL, ppm.edges.matrix = NULL)
}
\arguments{
\item{spectrum.list}{A list of the spectra (y-values). Since by definition some of these differ in length this has to be in list form with a single spectrum per list item.}

\item{ppm.list}{The list of corresponding ppm values (x-values) with the highest ppm-value at the beginning (left) as is the convention for NMR spectra. (This our ppm.edges.matrix has to be provided).}

\item{ppm.edges.matrix}{The list with the starting and ending ppm values (highest ppm-value on the left/in the beginning). This or ppm.list has to be provided.}
}
\value{
SpectraAndPPM A list with 2 elements, the DataMatrix and the ppmMatrix.
}
\description{
This function can be used to build a data matrix from ill aligned spectra or of spectra of unequal length.
the result is a matrix whereby the first column matches (approximately) with a single left ppm value and the 
last column matches (approximately) with a single right ppm value. Crucial is that the sample rates of the machine are the same
this should be always the case otherwise comparing intensities becomes meaningless.
Note that, as standard in NMR spectra, the highest ppm value is on the left
}
\examples{
# this is an example for 3 meaningless spectra
lengths_of_spectra <- c(100,150,120)
measurement_distance <- 0.01
starting_ppm_values <- c(8.7, 9.0, 9.0)
spectra <- list()
ppm_values <- list()
for (k in 1:3) {
    spectra[[k]] <- runif(lengths_of_spectra[k], min = 0, max = 10)
    
    # note the minus sign in the 'by' statement
    ppm_values[[k]] <- seq(from = starting_ppm_values[k], by = -measurement_distance, 
                           length.out = lengths_of_spectra[k])  
}
new.Data <- BuildRawDataMatrix(spectrum.list = spectra, ppm.list = ppm_values)
spectraMatrix <- new.Data$DataMatrix
ppmMatrix <- new.Data$ppmMatrix

}
\author{
Charlie Beirnaert, \email{charlie.beirnaert@uantwerpen.be}
}
