% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{formula_builder}
\alias{formula_builder}
\title{Builds models formulae with every combination of control variables possible.}
\usage{
formula_builder(y, x, controls, fixedEffects = NA)
}
\arguments{
\item{y}{A string containing the dependent variable name.}

\item{x}{A string containing the independent variable name.}

\item{controls}{A vector of strings containing control variable names.}

\item{fixedEffects}{A string containing the name of a variable to use for
fixed effects, defaults to `NA` indicating no fixed
effects desired.}
}
\value{
A vector of formula objects using every possible combination of
        controls.
}
\description{
Builds models formulae with every combination of control variables possible.
}
\examples{
formula_builder("dependentVariable", "independentVariable",
                c("control1", "control2"));
formula_builder("dependentVariable", "independentVariable",
                c("control1*control2"), fixedEffects="month");
}
