% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{se_boot}
\alias{se_boot}
\title{Estimates bootstrapped standard errors for regression models}
\usage{
se_boot(data, formula, n_x, n_samples, sample_size)
}
\arguments{
\item{data}{A data frame containing the variables provided in `formula`.}

\item{formula}{A string containing a regression formula, with or without
fixed effects.}

\item{n_x}{An integer representing the number of independent variables in
the regression.}

\item{n_samples}{An integer indicating how many times the model should be
estimated with a random subset of the data.}

\item{sample_size}{An integer indicating how many observations are in each
random subset of the data.}
}
\value{
A named list containing bootstrapped standard errors for each
        coefficient.
}
\description{
Takes in a data frame, regression formula, and bootstrapping parameters and
estimates bootstrapped standard errors for models with and without fixed
effects.
}
\examples{

se_boot(data = bottles, formula = "Salnty ~ T_degC + ChlorA + O2Sat",
        n_x = 3, n_samples = 4, sample_size = 300)

se_boot(data = data.frame(x1 = rnorm(50000, mean=4, sd=10),
                          x2 = rnorm(50000, sd=50),
                          ID = rep(1:100, 500),
                          area = rep(1:50, 1000),
                          y = rnorm(50000)),
        formula = "y ~ x1 + x2 | ID",
        n_x = 2, n_samples = 10, sample_size = 1000)

}
