% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMR_metabolite_identification.R
\name{nmr_identification}
\alias{nmr_identification}
\title{Function to do NMR metabolite identification}
\description{
This function performs metabolite identification on a dataset of nmr peaks, finding the top
5 reference metabolites that matched with each cluster of variables formed.
}
\usage{
nmr_identification(dataset, ppm.tol=0.03,
                   clust.method='pearson', clust.treshold=NULL, clust.peaks.min=2,
                   clust.maxPeaks=40, clust.nTop=5,
                   freq=500, nucl="1H", solv=NULL, pH=NULL, temp=NULL)
}
\arguments{
\item{dataset}{List representing the dataset from an nmr peaks metabolomics experiment.}

\item{ppm.tol}{ppm tolerance when matching reference peaks to the dataset peaks.}

\item{clust.method}{Correlation method to use in the formation of clusters. Defaults to "pearson".}

\item{clust.treshold}{Minimum correlation between variables to form clusters. If not given, the function calculates the optimum value (value that leads to the greater number of clusters).}

\item{clust.peaks.min}{Minimum number of variables in each cluster. Only the clusters with at least clust.peaks.min variables will be considered.}

\item{clust.nTop}{Number of top metabolites with greater score to show for each cluster.}

\item{clust.maxPeaks}{Maximum number of peaks that a cluster can have, while searching for the best correlation value. Defaults to 40, the original value where the code was adapated from. Can also be NULL and this value will be the number of peaks of the larger cluster.}

\item{freq}{Frequency of reference spectra. See documentation on \code{\link{choose_nmr_references}} function for further details.}

\item{nucl}{Atomic nuclei of reference spectra, either "1H" or "13C".}

\item{solv}{Solvent. See documentation on \code{\link{choose_nmr_references}} function for further details.}

\item{pH}{pH. See documentation on \code{\link{choose_nmr_references}} function for further details.}

\item{temp}{Temperature. See documentation on \code{\link{choose_nmr_references}} function for further details.}
}
\value{
List with of the results for each cluster. For each cluster:
\describe{
   \item{cluster.peaks}{The peaks of the cluster.}
   \item{summary}{Scores of each top 5 reference metabolite matched with the cluster.}
   \item{metabolites.matched}{List with full results for each top 5 reference metabolite matched.}
}
For each reference metabolite matched:
\describe{
   \item{score}{Jaccard index score.}
   \item{matched_peaks_ref}{Matched peaks of the reference spectra.}
   \item{matched_peaks_clust}{Matched peaks of the cluster.}
   \item{reference_peaks}{All the reference spectra peaks.}
}
}
\examples{
#data("propolis")
#propolis_mv=missingvalues_imputation(propolis)
#id_res=nmr_identification(propolis_mv, ppm.tol=0.03,
#                   clust.method='pearson', clust.maxPeaks=NULL, clust.nTop=10,
#                   freq=500, nucl="1H")
}
