% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AAA-Classes.R
\docType{class}
\name{Spectra-class}
\alias{Spectra-class}
\alias{spectacles}
\alias{SpectraDataFrame-class}
\alias{as.data.frame.Spectra}
\alias{as.data.frame.SpectraDataFrame}
\alias{as.data.frame.SpatialSpectra}
\alias{names.SpectraDataFrame}
\alias{names<-.SpectraDataFrame}
\alias{print,Spectra-method}
\alias{show,Spectra-method}
\alias{SpectraDataFrame-class}
\title{Spectra* classes}
\description{
The spectacles package provides the user with S4 classes that have been
developped to store and manipulate spectroscopy data.

The \code{Spectra} class is storing the spectra matrix, along with the
wavelengths at which those have been measured, the units in whioch those
wavelengths are expressed, and a unique id for each sample in the
collection.

The \code{SpectraDataFrame} class is extending the \code{Spectra} class by
giving the opportunity to store attribute data along with the spectra - this
is mostly the case when we want to predict physical or chemical properties
from the spectra set.

The \code{SpatialSpectra} and \code{SpatialSpectraDataFrame} classes are
extending the \code{Spectra} and \code{SpectraDataFrame} classes using the
\code{SpatialPoints} class from package sp. This allows to store spatial
information on the dataset: coordinates, coordinate reference system,
bounding box, etc.

Common generic methods implemented for these classes include:

\code{summary}, \code{show}, \code{nrow}, \code{length}, \code{plot},
\code{[}, \code{[[}, \code{$}.

\code{SpatialPoints} methods from the sp package can be applied to
\code{SpatialSpectra} and \code{SpatialSpectraDataFrame} objects are they
inherit from this class.

Class for spectra collections with associated attributes
}
\section{Slots}{

\describe{
\item{\code{wl}}{object of class "\code{numeric}"; the wavelengths at which the spectra has been measured}

\item{\code{nir}}{object of class "\code{matrix}"; the spectra, with as many columns as wavelengths, and as many rows as samples}

\item{\code{id}}{object of class "\code{data.frame}" with one attribute; the identification strings for each sample in the collection}

\item{\code{units}}{object of class "\code{character}"; units in which the wavelengths are expressed}

\item{\code{data}}{object of class data.frame containing the attribute data}
}}

\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new("Spectra", ...)}, with the constructor functions like
\code{Spectra(...)}, or with the helper functions such as \code{wl} and
\code{spectra}.
}

\examples{

showClass("Spectra")
showClass("SpectraDataFrame")

}
\author{
Pierre Roudier \email{pierre.roudier@gmail.com}

Pierre Roudier \email{pierre.roudier@gmail.com}
}
