% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\docType{methods}
\name{fill_spectra}
\alias{fill_spectra}
\alias{fill_spectra,Spectra-method}
\title{Fill missing wavelengths of a Spectra* object with a given value}
\usage{
\S4method{fill_spectra}{Spectra}(obj, ref = NULL, fill = NA, ...)
}
\arguments{
\item{obj}{an object inheriting from class \code{Spectra}}

\item{ref}{a numeric vector, giving the reference wavelengths (ie the entire
range of wavelengths expected to be in the spectra before some waveleng5ths
have been cut out). If NULL, the function is trying to guess it.}

\item{fill}{values to fill gaps in the data with}

\item{...}{ignored}
}
\value{
An object of the same class as \code{obj}
}
\description{
Fill missing wavelengths of a Spectra* object with a given value. This is
mostly usefull to include NA values in the spectra in order to show missing
bits in plots.
}
\details{
At this stage removing gaps does not work well with irreguarly spaced
wavelengths. Results might be odd for binned spectra.
}
\examples{

# Loading example data
data(australia)
spectra(australia) <- sr_no ~ ... ~ 350:2500

# Cut wavelengths out of the collection
oz <- cut(australia, wl=-1*c(355:400, 2480:2499))
big.head(spectra(oz), , 7)

# Giving the wavelengths at which I want data
oz_filled <- fill_spectra(oz, ref = 350:2500, fill = NA)
big.head(spectra(oz_filled), , 7)
plot(oz_filled)

# Trying to guess ref values
oz_filled <- fill_spectra(oz, fill = -999)
big.head(spectra(oz_filled), , 7)
plot(oz_filled)

}
\author{
Pierre Roudier \url{pierre.roudier@gmail.com}
}
