% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterLomb.R
\name{filter.lomb}
\alias{filter.lomb}
\title{Filter and reconstruction of data analysed via spec.lomb}
\usage{
filter.lomb(l = stop("No Lomb-Data"), newx = NULL, threshold = 6,
  filt = NULL, phase = "nextnb")
}
\arguments{
\item{l}{lomb object}

\item{newx}{vector of new values at which the restored function is to be evaluated}

\item{threshold}{statistical threshold in terms of a standard deaviation of
the amplidudes. It determines which frequencies are used. Lower values give
more frequencies.}

\item{filt}{vector or matix of frequencies (ranges) in which to select the frequencies}

\item{phase}{set the method to determine the phase at a given frequency (moegliche werte???)}
}
\value{
This function returns a list which contains the reconstruction according to the
\code{lomb}-object and \code{newx} for the given data \code{x} and \code{y}. The returned
object contains the following:
\describe{
\item{\code{x,y}}{reconstructed signal}
\item{\code{f,A,phi}}{used parameters from the \code{lomb}-object}
\item{\code{p}}{corresponding significance values}
}
}
\description{
Given an object of class \code{lomb}, this function allows the
reconstruction of the input signal using (a) a frequency selection
of single or multiple frequency (ranges), and/or (b) the most
significant peaks in the periodogram.
}
\details{
To properly reconstruct the signal out of the calculated
\code{lomb}-object, three different methods are available, which are
controlled by the \code{filt}-argument.
\enumerate{
\item If \code{filt=NULL}, the most significant values in the (dense) spectrum
are used.

\item If \code{filt=c(f1, .., fn)}, the given frequencies are used. The corresponding
phase is approximated.

\item If \code{class(filt)=="matrix"}, each row of the 2 x n matrix defines a
frequency range. With in each range the "significant" frequencies are selected for
reconstruction.
}
Prior to the reconstruction the \code{filter.lomb}-function calculates the
most significant amplitudes and corresponding phases. As a measure to select
the "correct" frequencies, the \code{threshold} argument can be adjusted.
The corresponding phases of the underlying sine/cosine-waves are estimated by
one of the four following methods.
\enumerate{
\item \code{phase=="nextnb"}... use the phase of the bin of nearest neighbour.
\item \code{phase=="lin"}... linear interpolation between the two closest bins.
\item \code{phase=="lockin"}... principle of lock-in amplification, also known as
quadrature-demodulation technique.
\item \code{phase=="fit"}... non-linear least squares fit with \code{stats::nls}
}
}

