% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenericFunctions.R,
%   R/spectralPreprocessing.R
\docType{methods}
\name{normalize}
\alias{normalize}
\alias{normalize,SpectraInTime-method}
\title{generic normalization function}
\usage{
normalize(object, ...)

\S4method{normalize}{SpectraInTime}(object, method = "normalize",
  wavelengthRange = r(-Inf, Inf), wavelength = NULL, scaleFunction = "sd",
  meanFunction = NULL)
}
\arguments{
\item{object}{a S4 class object}

\item{...}{additional parameters}

\item{method}{a method for normalization or peak correction , choose from:
* normalize substract \code{mean} and divide by \code{scale}
* peak scale by reference \code{wavelength}
* integrate scale by integrating over \code{wavelengthRange}}

\item{wavelengthRange}{range for integration if method = \code{integration} , defaults to complete range}

\item{wavelength}{reference wavelength for \code{peak} regresssion}

\item{scaleFunction}{scale function used when method = \code{normalize} defaults to \code{\link[stats]{sd}}}

\item{meanFunction}{mean function used when method = \code{normalize} defaults to \code{\link[base]{mean}}}
}
\description{
generic normalization function
}
\examples{
 spectralEx            <-  getSpectraInTimeExample()
 timeRange                        <-  range( getTimePoints( spectralEx ))
 timesToSelect                    <-  e(  seq( timeRange[1] , timeRange[2] , length.out = 5  )   )
 \dontrun{
 plot( spectralEx )
 plot( spectralEx[ timesToSelect ,  ] , type = "time" )
}
 normalizePeak         <-  normalize( spectralEx , method = "peak" , wavelength = 400 )
 getPreprocessing( normalizePeak )
\dontrun{
 plot( normalizePeak[ timesToSelect ,  ] , type = "time" )
 plot( normalizePeak )
}
 normalizeIntegration  <-  normalize( spectralEx , method = "integration" )
\dontrun{
 plot( normalizeIntegration[ timesToSelect ,  ] , type = "time" )
}
 normalizedUser  <-  normalize( spectralEx , method = "normalize" , mean = "median" , scale = "sd" )
\dontrun{
 plot( normalizedUser[ timesToSelect ,  ] , type = "time" ) 
}
}
