% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectralIntegration.R
\name{spectralIntegration}
\alias{spectralIntegration}
\title{Integrate spectraInTime object}
\usage{
spectralIntegration(object, wavelenghtRange, smoothingValue = 0,
  timeUnit = "seconds")
}
\arguments{
\item{object}{\code{\link{SpectraInTime-class}}}

\item{wavelenghtRange}{numeric vector of 2 elements i.e. integration limits}

\item{smoothingValue}{numeric value between 0 and 1, amount of code{\link[stats]{lowess}}-smoothing,
default to \code{0} i.e no smoothing. Note that smoothing is applied  after integration}

\item{timeUnit}{character value, choose between: \code{second , minutes and hours}, defaults to 
\code{seconds}}
}
\value{
\code{data.frame} with variables \code{time} and \code{integratedValue}
}
\description{
The integrated value over a user-specified wavelength range is calculated (trapezium rule) per time point, afterwards smoothing over time can be applied
}
\examples{
spectra                   <-  getSpectraInTimeExample()
defaults                  <-  spectralIntegration( spectra , c(200 , 300) , timeUnit = "hours" )
unsmoothedTrend           <-  spectralIntegration( spectra , c(200 , 300) , timeUnit = "hours" )
smoothedTrend             <-  spectralIntegration( spectra , c(200 , 300) ,
  smoothingValue = 0.5 , timeUnit = "hours" ) 
}
