% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetting.R
\name{subset-methods}
\alias{subset-methods}
\alias{[,SpectraInTime-method}
\alias{[,SpectraInTime,ANY,ANY,ANY-method}
\alias{[,SpectraInTime,ANY,ANY-method}
\alias{[,SpectraInTime,missing,ANY-method}
\alias{[,SpectraInTime,ANY,missing-method}
\alias{[,SpectraInTime,missing,missing-method}
\alias{[,SpectraInTimeComp,ANY,ANY-method}
\alias{[,SpectraInTimeComp,missing,ANY-method}
\alias{[,SpectraInTimeComp,ANY,missing-method}
\title{Subsetting  \code{\link{SpectraInTime-class}}}
\usage{
\S4method{[}{SpectraInTime,ANY,ANY}(x, i, j, ..., drop = "")

\S4method{[}{SpectraInTime,missing,ANY}(x, i, j, ..., drop = "")

\S4method{[}{SpectraInTime,ANY,missing}(x, i, j, ..., drop = "")

\S4method{[}{SpectraInTime,missing,missing}(x, i, j, ..., drop = "")

\S4method{[}{SpectraInTimeComp,ANY,ANY}(x, i, j, ..., drop = "")

\S4method{[}{SpectraInTimeComp,missing,ANY}(x, i, j, ..., drop = "")

\S4method{[}{SpectraInTimeComp,ANY,missing}(x, i, j, ..., drop = "")
}
\arguments{
\item{x}{object to subset}

\item{i}{subsetting rows ( timePoints )}

\item{j}{subsetting columns ( spectral axis )}

\item{...}{additional parameters 
  \itemize{
     \item timeUnit unit at which subsetting should be done choose between \code{seconds} , \code{minutes} or \code{hours} 
defaults to \code{seconds}
     \item   timePointsAlt logical indicators whater alternative timePoints should be used 
}}

\item{drop}{for consistancy, not used}
}
\value{
\code{\link{SpectraInTime-class}}
}
\description{
Subsetting  \code{\link{SpectraInTime-class}}
}
\examples{
 ### subsetting [ time , spectral axis, options ]

 spectralEx                <-  getSpectraInTimeExample()
 spectraSubset             <-  spectralEx[ r( 1000 , 30000 ) , r(130 , 135 ) ]
 spectraSubsetTime         <-  spectralEx[ r( 1000 , 30000 ) ,  ]
 spectraSubsetSpectralVals  <-  spectralEx[  ,  r(130 , 135 ) ]
 spectraSubsetHours        <-  spectralEx[ r( 1 , 3 ) , r(130 , 135 ) , timeUnit = "hours" ]
 closestSpectralVals        <-  spectralEx[ , e( 150, 4, 300, 500 ) ] # remark only unique values 
 spectraSubsetLogical      <-  spectralEx[ getTimePoints( spectralEx ) > 300   ,
 getSpectralAxis( spectralEx ) <= 500 ]
}
