% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothGraphLearning.R
\name{learn_graph_sigrep}
\alias{learn_graph_sigrep}
\title{Learn graphs from a smooth signal representation approach

This function learns a graph from a observed data matrix using the
method proposed by Dong (2016).}
\usage{
learn_graph_sigrep(
  X,
  alpha = 0.001,
  beta = 0.5,
  maxiter = 1000,
  ftol = 1e-04,
  verbose = TRUE
)
}
\arguments{
\item{X}{a p-by-n data matrix, where p is the number of nodes and n is the
number of observations}

\item{alpha}{hyperparameter that controls the importance of the Dirichlet
energy penalty}

\item{beta}{hyperparameter that controls the importance of the L2-norm
regularization}

\item{maxiter}{maximum number of iterations}

\item{ftol}{relative error on the objective function to be used as the
stopping criteria}

\item{verbose}{if TRUE, then a progress bar will be displayed in the console. Default is TRUE}
}
\value{
A list containing the following items
\item{\code{laplacian}}{estimated Laplacian Matrix}
\item{\code{Y}}{a smoothed approximation of the data matrix X}
\item{\code{convergence}}{whether or not the algorithm has converged within the tolerance and max number of iterations}
\item{\code{obj_fun}}{objective function value at every iteration, in case record_objective = TRUE}
}
\description{
Learn graphs from a smooth signal representation approach

This function learns a graph from a observed data matrix using the
method proposed by Dong (2016).
}
\references{
X. Dong, D. Thanou, P. Frossard and P. Vandergheynst, "Learning
            Laplacian Matrix in Smooth Graph Signal Representations,"
            in IEEE Transactions on Signal Processing, vol. 64, no. 23,
            pp. 6160-6173, Dec.1, 2016.
}
