/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.speedr.codegen;

import at.ac.ait.speedr.codegen.FilterExpressionRCodeGen;
import at.ac.ait.speedr.codegen.FilterFunctionCodeGen;
import at.ac.ait.speedr.importwizard.steps.DataImportPanelUserActionListener;
import at.ac.arcs.tablefilter.events.FilterEvent;
import at.ac.arcs.tablefilter.events.FilterListener;
import at.ac.arcs.tablefilter.filtermodel.NumericFilterDevice;
import at.ac.arcs.tablefilter.filtermodel.info.FilterColumnInfo;
import at.ac.arcs.tablefilter.filtermodel.info.FilterInfo;
import at.ac.arcs.tablefilter.filtermodel.info.FilterRowInfo;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableModel;
import org.ait.table.filter.FilterExpressionLexer;
import org.ait.table.filter.FilterExpressionParser;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;

public class ImportAndFilterCodeGen
implements FilterListener,
DataImportPanelUserActionListener {
    private static final Logger logger = Logger.getLogger(ImportAndFilterCodeGen.class.getName());
    private static StringTemplateGroup filter_stg;
    private static StringTemplateGroup import_stg;
    private static StringTemplateGroup importandfilter_stg;
    private EventListenerList listenerList = new EventListenerList();
    private StringTemplate importanyfunction;
    private StringTemplate file;
    private StringTemplate delimiter;
    private StringTemplate textqualifier;
    private StringTemplate rowstart;
    private StringTemplate rowend;
    private StringTemplate colstart;
    private StringTemplate colend;
    private StringTemplate hasRowNamesST;
    private StringTemplate rowNamesColumnIndexST;
    private StringTemplate hasColumnNames;
    private StringTemplate columnNamesRowIndex;
    private ChangeEvent changeEvent;
    private String variablename = "temp";
    private String filterFunctionName = "temp_filter";
    private TableModel model;
    private String importcode = "";
    private String filtercode = "";
    private boolean hasRowNames = false;
    private int rowNamesColumnIndex = 1;
    private int rowstartIndex = 1;
    private int rowendIndex = 0;
    private int colstartIndex = 1;
    private int colendIndex = 0;
    private HashMap<Integer, HashMap<Integer, Object>> cellUpdates = new HashMap();

    public ImportAndFilterCodeGen() throws IOException {
        if (importandfilter_stg == null) {
            InputStreamReader r = new InputStreamReader(ImportAndFilterCodeGen.class.getResourceAsStream("/at/ac/ait/speedr/codegen/template/ImportCodeGen.stg"));
            import_stg = new StringTemplateGroup((Reader)r);
            r.close();
            r = new InputStreamReader(ImportAndFilterCodeGen.class.getResourceAsStream("/at/ac/ait/speedr/codegen/template/RCodeGen.stg"));
            filter_stg = new StringTemplateGroup((Reader)r);
            r.close();
            r = new InputStreamReader(ImportAndFilterCodeGen.class.getResourceAsStream("/at/ac/ait/speedr/codegen/template/ImportAndFilterCodeGen.stg"));
            importandfilter_stg = new StringTemplateGroup((Reader)r);
            r.close();
        }
    }

    public void setImportcode(String importcode) {
        this.importcode = importcode;
    }

    public void setFiltercode(String filtercode) {
        this.filtercode = filtercode;
    }

    private void setFiltercode() {
        this.importanyfunction = import_stg.getInstanceOf("importany");
        this.importanyfunction.setAttribute("varname", (Object)this.variablename);
        if (this.file != null) {
            this.importanyfunction.setAttribute("params", (Object)this.file);
        }
        if (this.delimiter != null) {
            this.importanyfunction.setAttribute("params", (Object)this.delimiter);
        }
        if (this.textqualifier != null) {
            this.importanyfunction.setAttribute("params", (Object)this.textqualifier);
        }
        if (this.rowstart != null) {
            this.importanyfunction.setAttribute("params", (Object)this.rowstart);
        }
        if (this.rowend != null) {
            this.importanyfunction.setAttribute("params", (Object)this.rowend);
        }
        if (this.colstart != null) {
            this.importanyfunction.setAttribute("params", (Object)this.colstart);
        }
        if (this.colend != null) {
            this.importanyfunction.setAttribute("params", (Object)this.colend);
        }
        if (this.hasRowNamesST != null) {
            this.importanyfunction.setAttribute("params", (Object)this.hasRowNamesST);
        }
        if (this.rowNamesColumnIndexST != null) {
            this.importanyfunction.setAttribute("params", (Object)this.rowNamesColumnIndexST);
        }
        if (this.hasColumnNames != null) {
            this.importanyfunction.setAttribute("params", (Object)this.hasColumnNames);
        }
        if (this.columnNamesRowIndex != null) {
            this.importanyfunction.setAttribute("params", (Object)this.columnNamesRowIndex);
        }
        this.importcode = this.importanyfunction.toString();
    }

    public String getImportAndFilterCode() {
        this.setFiltercode();
        StringTemplate t = importandfilter_stg.getInstanceOf("importandfilter");
        t.setAttribute("params", (Object)this.importcode);
        StringTemplate cellUpdates = this.generateCellUpdates();
        if (cellUpdates != null) {
            t.setAttribute("params", (Object)cellUpdates);
        }
        t.setAttribute("params", (Object)this.filtercode);
        if (this.filtercode != null && !this.filtercode.equals("")) {
            t.setAttribute("params", (Object)(this.variablename + "<-" + this.getFilterFunctionName() + "(" + this.variablename + ")"));
        }
        return t.toString();
    }

    public void filterChanged(FilterEvent event) {
        FilterRowInfo[] filterRows;
        StringTemplate filterfunction = filter_stg.getInstanceOf("filterfunction");
        filterfunction.setAttribute("functionname", (Object)this.getFilterFunctionName());
        FilterInfo filterInfo = event.getFilterInfo();
        for (FilterRowInfo filterRowInfo : filterRows = filterInfo.getFilterRows()) {
            StringTemplate filterlevel = filter_stg.getInstanceOf("filterlevel");
            List columns = filterRowInfo.getColumns();
            if (columns.isEmpty()) {
                filterfunction.setAttribute("filterlevels", (Object)"(T)");
                continue;
            }
            for (FilterColumnInfo filterColumnInfo : columns) {
                String exp = filterColumnInfo.getExpression();
                try {
                    ANTLRStringStream input = new ANTLRStringStream(exp);
                    FilterExpressionLexer lexer = new FilterExpressionLexer((CharStream)input);
                    CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
                    FilterExpressionParser parser = new FilterExpressionParser((TokenStream)tokens);
                    parser.setNumberColumn(filterInfo.getFilterDevices()[filterColumnInfo.getColumn()] instanceof NumericFilterDevice);
                    FilterExpressionParser.formula_return formula = parser.formula();
                    CommonTree tree = (CommonTree)formula.getTree();
                    CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)tree);
                    nodes.setTokenStream((TokenStream)tokens);
                    FilterExpressionRCodeGen rcodegen = new FilterExpressionRCodeGen((TreeNodeStream)nodes);
                    if (this.model.getColumnName(0).equals("row.names")) {
                        rcodegen.setHasRowNames(true);
                    }
                    int col = filterColumnInfo.getColumn();
                    if (rcodegen.hasRowNames() && col == 0) {
                        rcodegen.setColumnIndex(null);
                    } else if (this.model.getColumnCount() == 1) {
                        rcodegen.setColumnIndex("[1]");
                    } else {
                        try {
                            Integer.parseInt(this.model.getColumnName(col));
                            rcodegen.setColumnIndex("[," + this.model.getColumnName(col) + "]");
                        }
                        catch (NumberFormatException numberFormatException) {
                            rcodegen.setColumnIndex("[[\"" + this.model.getColumnName(col) + "\"]]");
                        }
                    }
                    rcodegen.setTemplateLib(filter_stg);
                    FilterExpressionRCodeGen.rcode_return rcode = rcodegen.rcode();
                    filterlevel.setAttribute("selectors", (Object)rcode.st);
                }
                catch (RecognitionException recognitionException) {
                    Logger.getLogger(FilterFunctionCodeGen.class.getName()).log(Level.SEVERE, "Can't parse the expression: " + exp, recognitionException);
                }
            }
            filterfunction.setAttribute("filterlevels", (Object)filterlevel);
        }
        this.filtercode = filterfunction.toString();
        this.fireStateChanged();
    }

    private String getFilterFunctionName() {
        return this.filterFunctionName;
    }

    private void setFilterFunctionName() {
        this.filterFunctionName = this.filterFunctionName = this.variablename + "_filter";
    }

    public void setFile(String path) {
        this.file = import_stg.getInstanceOf("file");
        this.file.setAttribute("value", (Object)path);
    }

    public void separatorChanged(String newvalue) {
        this.delimiter = import_stg.getInstanceOf("separator");
        this.delimiter.setAttribute("value", (Object)newvalue);
        this.fireStateChanged();
    }

    public void quoteChanged(String newvalue) {
        if (newvalue == null) {
            this.textqualifier = null;
        } else {
            this.textqualifier = import_stg.getInstanceOf("quote");
            this.textqualifier.setAttribute("value", (Object)newvalue);
            this.fireStateChanged();
        }
    }

    public void rowStartChanged(int newvalue) {
        this.rowstartIndex = newvalue;
        this.rowstart = import_stg.getInstanceOf("rowstart");
        this.rowstart.setAttribute("value", newvalue);
        this.fireStateChanged();
    }

    public void rowEndChange(int newvalue) {
        this.rowendIndex = newvalue;
        this.rowend = import_stg.getInstanceOf("rowend");
        this.rowend.setAttribute("value", newvalue);
        this.fireStateChanged();
    }

    public void colStartChanged(int newvalue) {
        this.colstartIndex = newvalue;
        this.colstart = import_stg.getInstanceOf("colstart");
        this.colstart.setAttribute("value", newvalue);
        this.fireStateChanged();
    }

    public void colEndChange(int newvalue) {
        this.colendIndex = newvalue;
        this.colend = import_stg.getInstanceOf("colend");
        this.colend.setAttribute("value", newvalue);
        this.fireStateChanged();
    }

    public void hasRowHeaderChanged(Boolean newvalue) {
        this.hasColumnNames = import_stg.getInstanceOf("hasColumnNames");
        this.hasColumnNames.setAttribute("value", (Object)newvalue.toString().toUpperCase());
        this.fireStateChanged();
    }

    public void columnNamesRowIndexChanged(int newvalue) {
        this.columnNamesRowIndex = import_stg.getInstanceOf("columnNamesRowIndex");
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "new columnNamesRowIndex = {0}", newvalue);
        }
        this.columnNamesRowIndex.setAttribute("value", newvalue);
        this.fireStateChanged();
    }

    public void hasRowNamesChanged(Boolean newvalue) {
        this.hasRowNames = newvalue;
        this.hasRowNamesST = import_stg.getInstanceOf("hasRowNames");
        this.hasRowNamesST.setAttribute("value", (Object)newvalue.toString().toUpperCase());
        this.fireStateChanged();
    }

    public void rowNamesNoChanged(int newvalue) {
        this.rowNamesColumnIndex = newvalue;
        this.rowNamesColumnIndexST = import_stg.getInstanceOf("rowNamesColumnIndex");
        this.rowNamesColumnIndexST.setAttribute("value", newvalue);
        this.fireStateChanged();
    }

    public void variableNameChanged(String newvalue) {
        String oldFilterFunctionName = this.getFilterFunctionName();
        this.variablename = newvalue;
        this.setFilterFunctionName();
        String newFilterFunctionName = this.getFilterFunctionName();
        this.filtercode = this.filtercode.replaceFirst(oldFilterFunctionName, newFilterFunctionName);
        this.fireStateChanged();
    }

    public void tableCellValueChanged(Object aValue, int rowIndex, int columnIndex) {
        Integer realRowIndex = this.rowstartIndex + rowIndex;
        Integer realColumnIndex = this.hasRowNames && columnIndex == 0 ? Integer.valueOf(this.rowNamesColumnIndex) : Integer.valueOf(this.colstartIndex + columnIndex);
        if (!this.cellUpdates.containsKey(realRowIndex)) {
            this.cellUpdates.put(realRowIndex, new HashMap());
        }
        this.cellUpdates.get(realRowIndex).put(realColumnIndex, aValue);
        this.fireStateChanged();
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public void setModel(TableModel model) {
        this.model = model;
    }

    private StringTemplate generateCellUpdates() {
        StringTemplate updates = null;
        for (Integer rowIndex : this.cellUpdates.keySet()) {
            if (!this.isRowInTheRange(rowIndex)) continue;
            if (updates == null) {
                updates = import_stg.getInstanceOf("cellUpdates");
            }
            for (Integer columnIndex : this.cellUpdates.get(rowIndex).keySet()) {
                if (!this.isColumnInTheRange(columnIndex)) continue;
                StringTemplate update = this.hasRowNames && columnIndex == this.rowNamesColumnIndex ? this.createRowNamesUpdateST(rowIndex) : this.createCellUpdateST(rowIndex, columnIndex);
                updates.setAttribute("allCellUpdates", (Object)update);
            }
        }
        return updates;
    }

    private boolean isRowInTheRange(int rowIndex) {
        return rowIndex >= this.rowstartIndex && (rowIndex <= this.rowendIndex || this.rowendIndex == 0);
    }

    private boolean isColumnInTheRange(int columnIndex) {
        if (this.hasRowNames && columnIndex == this.rowNamesColumnIndex) {
            return true;
        }
        if (this.hasRowNames) {
            if (columnIndex < this.rowNamesColumnIndex) {
                return columnIndex >= this.colstartIndex && (this.colendIndex == 0 || columnIndex - 1 <= this.colendIndex);
            }
            return columnIndex >= this.colstartIndex + 1 && (this.colendIndex == 0 || columnIndex - 1 <= this.colendIndex);
        }
        return columnIndex >= this.colstartIndex && (columnIndex <= this.colendIndex || this.colendIndex == 0);
    }

    private StringTemplate createCellUpdateST(Integer rowIndex, Integer columnIndex) {
        StringTemplate update = import_stg.getInstanceOf("cellUpdate");
        update.setAttribute("varname", (Object)this.variablename);
        if (this.cellUpdates.get(rowIndex).get(columnIndex) == null || this.cellUpdates.get(rowIndex).get(columnIndex).equals("")) {
            update.setAttribute("value", (Object)"NA");
        } else if (this.cellUpdates.get(rowIndex).get(columnIndex) instanceof Number) {
            update.setAttribute("value", this.cellUpdates.get(rowIndex).get(columnIndex));
        } else {
            update.setAttribute("value", (Object)("\"" + this.cellUpdates.get(rowIndex).get(columnIndex) + "\""));
        }
        update.setAttribute("rowIndex", rowIndex - this.rowstartIndex + 1);
        if (this.hasRowNames && columnIndex > this.rowNamesColumnIndex) {
            update.setAttribute("columnIndex", columnIndex - this.colstartIndex);
        } else {
            update.setAttribute("columnIndex", columnIndex - this.colstartIndex + 1);
        }
        return update;
    }

    private StringTemplate createRowNamesUpdateST(int rowIndex) {
        StringTemplate update = import_stg.getInstanceOf("rownameUpdate");
        update.setAttribute("varname", (Object)this.variablename);
        update.setAttribute("rowIndex", rowIndex - this.rowstartIndex + 1);
        update.setAttribute("value", (Object)("\"" + this.cellUpdates.get(rowIndex).get(this.rowNamesColumnIndex) + "\""));
        return update;
    }
}

