/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.speedr;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.calendar.SingleDaySelectionModel;

public class DateTimePicker
extends JXDatePicker {
    private JSpinner timeSpinner;
    private JPanel timePanel;
    private DateFormat timeFormat;
    private boolean spinnerUsed = false;

    public DateTimePicker() {
        this.getMonthView().setSelectionModel((DateSelectionModel)new SingleDaySelectionModel());
    }

    public DateTimePicker(Date d) {
        this();
        this.setDate(d);
    }

    public DateTimePicker(DateFormat dateFormat) {
        this.getMonthView().setSelectionModel((DateSelectionModel)new SingleDaySelectionModel());
        this.setFormats(new DateFormat[]{dateFormat});
        this.timeFormat = new SimpleDateFormat("HH:mm:ss");
        this.updateTextFieldFormat();
    }

    public void commitEdit() throws ParseException {
        super.commitEdit();
        this.commitTime();
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setTimeSpinners();
    }

    public JPanel getLinkPanel() {
        super.getLinkPanel();
        if (this.timePanel == null) {
            this.timePanel = this.createTimePanel();
        }
        this.setTimeSpinners();
        return this.timePanel;
    }

    private JPanel createTimePanel() {
        JPanel newPanel = new JPanel();
        newPanel.setLayout(new FlowLayout());
        SpinnerDateModel dateModel = new SpinnerDateModel();
        this.timeSpinner = new JSpinner(dateModel);
        this.timeSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DateTimePicker.this.spinnerUsed = true;
            }
        });
        if (this.timeFormat == null) {
            this.timeFormat = DateFormat.getTimeInstance(3);
        }
        this.updateTextFieldFormat();
        newPanel.add(new JLabel("Time:"));
        newPanel.add(this.timeSpinner);
        newPanel.setBackground(Color.WHITE);
        return newPanel;
    }

    private void updateTextFieldFormat() {
        if (this.timeSpinner == null) {
            return;
        }
        JFormattedTextField tf = ((JSpinner.DefaultEditor)this.timeSpinner.getEditor()).getTextField();
        DefaultFormatterFactory factory = (DefaultFormatterFactory)tf.getFormatterFactory();
        DateFormatter formatter = (DateFormatter)factory.getDefaultFormatter();
        formatter.setFormat(this.timeFormat);
    }

    private void commitTime() {
        Date date = this.getDate();
        if (date != null) {
            if (this.spinnerUsed) {
                Date time = (Date)this.timeSpinner.getValue();
                GregorianCalendar timeCalendar = new GregorianCalendar();
                timeCalendar.setTime(time);
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(date);
                calendar.set(11, timeCalendar.get(11));
                calendar.set(12, timeCalendar.get(12));
                calendar.set(13, timeCalendar.get(13));
                calendar.set(14, 0);
                Date newDate = calendar.getTime();
                this.setDate(newDate);
            } else {
                this.timeSpinner.setValue(date);
            }
        }
        this.spinnerUsed = false;
    }

    private void setTimeSpinners() {
        Date date = this.getDate();
        if (date != null) {
            this.timeSpinner.setValue(date);
        }
    }

    public DateFormat getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(DateFormat timeFormat) {
        this.timeFormat = timeFormat;
        this.updateTextFieldFormat();
    }

    public static void main(String[] args) {
        Date date = new Date();
        JFrame frame = new JFrame();
        frame.setTitle("Date Time Picker");
        frame.setDefaultCloseOperation(3);
        DateTimePicker dateTimePicker = new DateTimePicker();
        dateTimePicker.setFormats(new DateFormat[]{DateFormat.getDateTimeInstance(3, 2)});
        dateTimePicker.setTimeFormat(DateFormat.getTimeInstance(2));
        dateTimePicker.setDate(date);
        frame.getContentPane().add((Component)((Object)dateTimePicker));
        frame.pack();
        frame.setVisible(true);
    }
}

