/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.bubble;

import bibliothek.extension.gui.dock.theme.bubble.BubbleColorAnimation;
import bibliothek.extension.gui.dock.theme.bubble.BubbleStackDockComponent;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.station.stack.CombinedTab;
import bibliothek.gui.dock.station.stack.tab.Tab;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.TabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.themes.color.TabColor;
import bibliothek.gui.dock.themes.font.TabFont;
import bibliothek.gui.dock.util.font.FontModifier;
import bibliothek.gui.dock.util.swing.OrientedLabel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;

public class BubbleTab
extends JPanel
implements CombinedTab,
ChangeListener,
Runnable,
DockableFocusListener {
    private OrientedLabel label = new OrientedLabel();
    private BubbleColorAnimation animation;
    private boolean mouse = false;
    private boolean focused = false;
    private Dockable dockable;
    private DockController controller;
    private BubbleStackDockComponent parent;
    private int zOrder;
    private int arc = 6;
    private int borderSize;
    private int freeSpaceToSideBorder = this.borderSize = 3;
    private int freeSpaceToParallelBorder = 0;
    private TabPlacement orientation = TabPlacement.TOP_OF_DOCKABLE;
    private BubbleTabColor topMouse;
    private BubbleTabColor bottomMouse;
    private BubbleTabColor borderMouse;
    private BubbleTabColor textMouse;
    private BubbleTabColor top;
    private BubbleTabColor bottom;
    private BubbleTabColor border;
    private BubbleTabColor text;
    private BubbleTabColor topSelectedMouse;
    private BubbleTabColor bottomSelectedMouse;
    private BubbleTabColor borderSelectedMouse;
    private BubbleTabColor textSelectedMouse;
    private BubbleTabColor topSelected;
    private BubbleTabColor bottomSelected;
    private BubbleTabColor borderSelected;
    private BubbleTabColor textSelected;
    private BubbleTabColor topFocusedMouse;
    private BubbleTabColor bottomFocusedMouse;
    private BubbleTabColor borderFocusedMouse;
    private BubbleTabColor textFocusedMouse;
    private BubbleTabColor topFocused;
    private BubbleTabColor bottomFocused;
    private BubbleTabColor borderFocused;
    private BubbleTabColor textFocused;
    private BubbleTabColor[] colors;
    private BubbleTabFont fontFocused;
    private BubbleTabFont fontSelected;
    private BubbleTabFont fontUnselected;
    private static final int STATE_SELECTED = 1;
    private static final int STATE_FOCUSED = 3;
    private static final int STATE_MOUSE = 4;
    private int state = 0;

    public BubbleTab(BubbleStackDockComponent bubbleStackDockComponent, Dockable dockable) {
        this.dockable = dockable;
        this.parent = bubbleStackDockComponent;
        this.label.setHorizontal(this.orientation.isHorizontal());
        this.animation = new BubbleColorAnimation();
        this.animation.addTask(this);
        this.topMouse = new BubbleTabColor(4, "stack.tab.background.top.mouse", "top", this.animation, dockable, Color.RED.brighter());
        this.bottomMouse = new BubbleTabColor(4, "stack.tab.background.bottom.mouse", "bottom", this.animation, dockable, Color.RED.darker());
        this.borderMouse = new BubbleTabColor(4, "stack.tab.border.mouse", "border", this.animation, dockable, Color.RED.darker().darker());
        this.textMouse = new BubbleTabColor(4, "stack.tab.foreground.mouse", "text", this.animation, dockable, Color.BLACK);
        this.top = new BubbleTabColor(0, "stack.tab.background.top", "top", this.animation, dockable, Color.RED.brighter());
        this.bottom = new BubbleTabColor(0, "stack.tab.background.bottom", "bottom", this.animation, dockable, Color.RED.darker());
        this.border = new BubbleTabColor(0, "stack.tab.border", "border", this.animation, dockable, Color.RED.darker().darker());
        this.text = new BubbleTabColor(0, "stack.tab.foreground", "text", this.animation, dockable, Color.BLACK);
        this.topSelectedMouse = new BubbleTabColor(5, "stack.tab.background.top.selected.mouse", "top", this.animation, dockable, Color.RED.brighter());
        this.bottomSelectedMouse = new BubbleTabColor(5, "stack.tab.background.bottom.selected.mouse", "bottom", this.animation, dockable, Color.RED.darker());
        this.borderSelectedMouse = new BubbleTabColor(5, "stack.tab.border.selected.mouse", "border", this.animation, dockable, Color.RED.darker().darker());
        this.textSelectedMouse = new BubbleTabColor(5, "stack.tab.foreground.selected.mouse", "text", this.animation, dockable, Color.BLACK);
        this.topSelected = new BubbleTabColor(1, "stack.tab.background.top.selected", "top", this.animation, dockable, Color.RED.brighter());
        this.bottomSelected = new BubbleTabColor(1, "stack.tab.background.bottom.selected", "bottom", this.animation, dockable, Color.RED.darker());
        this.borderSelected = new BubbleTabColor(1, "stack.tab.border.selected", "border", this.animation, dockable, Color.RED.darker().darker());
        this.textSelected = new BubbleTabColor(1, "stack.tab.foreground.selected", "text", this.animation, dockable, Color.BLACK);
        this.topFocusedMouse = new BubbleTabColor(7, "stack.tab.background.top.focused.mouse", "top", this.animation, dockable, Color.RED.brighter());
        this.bottomFocusedMouse = new BubbleTabColor(7, "stack.tab.background.bottom.focused.mouse", "bottom", this.animation, dockable, Color.RED.darker());
        this.borderFocusedMouse = new BubbleTabColor(7, "stack.tab.border.focused.mouse", "border", this.animation, dockable, Color.RED.darker().darker());
        this.textFocusedMouse = new BubbleTabColor(7, "stack.tab.foreground.focused.mouse", "text", this.animation, dockable, Color.BLACK);
        this.topFocused = new BubbleTabColor(3, "stack.tab.background.top.focused", "top", this.animation, dockable, Color.RED.brighter());
        this.bottomFocused = new BubbleTabColor(3, "stack.tab.background.bottom.focused", "bottom", this.animation, dockable, Color.RED.darker());
        this.borderFocused = new BubbleTabColor(3, "stack.tab.border.focused", "border", this.animation, dockable, Color.RED.darker().darker());
        this.textFocused = new BubbleTabColor(3, "stack.tab.foreground.focused", "text", this.animation, dockable, Color.BLACK);
        this.colors = new BubbleTabColor[]{this.top, this.bottom, this.border, this.text, this.topMouse, this.bottomMouse, this.borderMouse, this.textMouse, this.topSelected, this.bottomSelected, this.borderSelected, this.textSelected, this.topSelectedMouse, this.bottomSelectedMouse, this.borderSelectedMouse, this.textSelectedMouse, this.topFocused, this.bottomFocused, this.borderFocused, this.textFocused, this.topFocusedMouse, this.bottomFocusedMouse, this.borderFocusedMouse, this.textFocusedMouse};
        this.fontFocused = new BubbleTabFont("tab.focused", dockable);
        this.fontSelected = new BubbleTabFont("tab.selected", dockable);
        this.fontUnselected = new BubbleTabFont("tab.unselected", dockable);
        this.setController(bubbleStackDockComponent.getController());
        this.checkAnimation();
        this.setOpaque(false);
        this.add(this.label);
        this.setLayout(null);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                BubbleTab.this.parent.setSelectedDockable(BubbleTab.this.dockable);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                BubbleTab.this.mouse = true;
                BubbleTab.this.checkAnimation();
            }

            public void mouseExited(MouseEvent mouseEvent) {
                BubbleTab.this.mouse = false;
                BubbleTab.this.checkAnimation();
            }
        };
        this.addMouseListener(mouseAdapter);
        this.label.addMouseListener(mouseAdapter);
    }

    public TabPane getTabParent() {
        return this.parent;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public Point getPopupLocation(Point point, boolean bl) {
        if (bl) {
            return point;
        }
        return null;
    }

    public void setTooltip(String string) {
        this.setToolTipText(string);
        this.label.setToolTipText(string);
    }

    public void setPaneVisible(boolean bl) {
        this.parent.getTabHandler().setVisible(this, bl);
    }

    public boolean isPaneVisible() {
        return this.parent.getTabHandler().isVisible(this);
    }

    public void setOrientation(TabPlacement tabPlacement) {
        if (tabPlacement == null) {
            throw new IllegalArgumentException("orientation must not be null");
        }
        if (this.orientation != tabPlacement) {
            this.orientation = tabPlacement;
            this.label.setHorizontal(tabPlacement.isHorizontal());
            this.revalidate();
            this.repaint();
        }
    }

    public int getState() {
        return this.state;
    }

    public void setController(DockController dockController) {
        if (this.controller != null) {
            this.controller.removeDockableFocusListener(this);
        }
        for (BubbleTabColor bubbleTabColor : this.colors) {
            bubbleTabColor.connect(dockController);
        }
        this.fontFocused.connect(dockController);
        this.fontSelected.connect(dockController);
        this.fontUnselected.connect(dockController);
        this.controller = dockController;
        if (dockController != null) {
            dockController.addDockableFocusListener(this);
            this.focused = dockController.getFocusedDockable() == this.dockable;
        }
        this.checkAnimation();
        this.animation.kick();
    }

    public void setZOrder(int n) {
        this.zOrder = n;
    }

    public int getZOrder() {
        return this.zOrder;
    }

    public Insets getOverlap(TabPaneComponent tabPaneComponent) {
        return new Insets(0, 0, 0, 0);
    }

    public void dockableFocused(DockableFocusEvent dockableFocusEvent) {
        boolean bl = this.focused;
        boolean bl2 = this.focused = this.dockable == dockableFocusEvent.getNewFocusOwner();
        if (bl != this.focused) {
            this.checkAnimation();
        }
    }

    public void run() {
        this.label.setForeground(this.animation.getColor("text"));
        this.repaint();
    }

    public Dimension getPreferredSize(Tab[] tabArray) {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.label.getPreferredSize();
        if (this.orientation.isHorizontal()) {
            return new Dimension(dimension.width + 2 * this.borderSize + 2 * this.freeSpaceToSideBorder, dimension.height + 2 * this.arc + this.borderSize + this.freeSpaceToParallelBorder);
        }
        return new Dimension(dimension.width + 2 * this.arc + this.borderSize + this.freeSpaceToParallelBorder, dimension.height + 2 * this.borderSize + 2 * this.freeSpaceToSideBorder);
    }

    public Dimension getMinimumSize(Tab[] tabArray) {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void doLayout() {
        switch (this.orientation) {
            case TOP_OF_DOCKABLE: {
                this.label.setBounds(this.borderSize + this.freeSpaceToSideBorder, this.borderSize + this.freeSpaceToParallelBorder + this.borderSize, this.getWidth() - 2 * this.borderSize - 2 * this.freeSpaceToSideBorder, this.getHeight() - this.arc - this.borderSize - this.freeSpaceToParallelBorder);
                break;
            }
            case BOTTOM_OF_DOCKABLE: {
                this.label.setBounds(this.borderSize + this.freeSpaceToSideBorder, this.borderSize + this.freeSpaceToParallelBorder, this.getWidth() - 2 * this.borderSize - 2 * this.freeSpaceToSideBorder, this.getHeight() - this.arc - this.borderSize - this.freeSpaceToParallelBorder);
                break;
            }
            case RIGHT_OF_DOCKABLE: {
                this.label.setBounds(this.borderSize + this.freeSpaceToParallelBorder, this.borderSize + this.freeSpaceToSideBorder, this.getWidth() - this.arc - this.borderSize - this.freeSpaceToParallelBorder, this.getHeight() - 2 * this.borderSize - 2 * this.freeSpaceToSideBorder);
                break;
            }
            case LEFT_OF_DOCKABLE: {
                this.label.setBounds(this.borderSize + this.freeSpaceToParallelBorder + this.freeSpaceToSideBorder, this.borderSize + this.freeSpaceToSideBorder, this.getWidth() - this.arc - this.borderSize - this.freeSpaceToParallelBorder, this.getHeight() - 2 * this.borderSize - 2 * this.freeSpaceToSideBorder);
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        Color color = this.animation.getColor("bottom");
        Color color2 = this.animation.getColor("top");
        Color color3 = this.animation.getColor("border");
        int n = this.getWidth();
        int n2 = this.getHeight();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(color3);
        switch (this.orientation) {
            case TOP_OF_DOCKABLE: {
                graphics2D.fillRoundRect(0, 0, n, n2 + this.arc, 2 * this.arc, 2 * this.arc);
                break;
            }
            case BOTTOM_OF_DOCKABLE: {
                graphics2D.fillRoundRect(0, -this.arc, n, n2 + this.arc, 2 * this.arc, 2 * this.arc);
                break;
            }
            case LEFT_OF_DOCKABLE: {
                graphics2D.fillRoundRect(0, 0, n + this.arc, n2, 2 * this.arc, 2 * this.arc);
                break;
            }
            case RIGHT_OF_DOCKABLE: {
                graphics2D.fillRoundRect(-this.arc, 0, n + this.arc, n2, 2 * this.arc, 2 * this.arc);
            }
        }
        if (this.orientation.isHorizontal()) {
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color2, 0.0f, n2 - this.borderSize, color));
        } else {
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color2, n - this.borderSize, 0.0f, color));
        }
        switch (this.orientation) {
            case TOP_OF_DOCKABLE: {
                graphics2D.fillRoundRect(this.borderSize, this.borderSize, n - 2 * this.borderSize, n2 + this.arc - this.borderSize, 2 * this.arc, 2 * this.arc);
                break;
            }
            case BOTTOM_OF_DOCKABLE: {
                graphics2D.fillRoundRect(this.borderSize, -this.arc, n - 2 * this.borderSize, n2 + this.arc - this.borderSize, 2 * this.arc, 2 * this.arc);
                break;
            }
            case LEFT_OF_DOCKABLE: {
                graphics2D.fillRoundRect(this.borderSize, this.borderSize, n + this.arc - this.borderSize, n2 - 2 * this.borderSize, 2 * this.arc, 2 * this.arc);
                break;
            }
            case RIGHT_OF_DOCKABLE: {
                graphics2D.fillRoundRect(-this.arc, this.borderSize, n + this.arc - this.borderSize, n2 - 2 * this.borderSize, 2 * this.arc, 2 * this.arc);
            }
        }
        Graphics graphics2 = graphics.create(this.label.getX(), this.label.getY(), this.label.getWidth(), this.label.getHeight());
        this.label.paint(graphics2);
        graphics2.dispose();
        if (this.orientation.isHorizontal()) {
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, new Color(150, 150, 150), 0.0f, n2 / 2, Color.WHITE));
        } else {
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, new Color(150, 150, 150), n / 2, 0.0f, Color.WHITE));
        }
        graphics2D.setComposite(AlphaComposite.getInstance(10, 0.4f));
        switch (this.orientation) {
            case TOP_OF_DOCKABLE: {
                graphics2D.setClip(new RoundRectangle2D.Float(0.0f, 0.0f, n, n2 + this.arc, 2 * this.arc, 2 * this.arc));
                break;
            }
            case BOTTOM_OF_DOCKABLE: {
                graphics2D.setClip(new RoundRectangle2D.Float(0.0f, -this.arc, n, n2 + this.arc, 2 * this.arc, 2 * this.arc));
                break;
            }
            case LEFT_OF_DOCKABLE: {
                graphics2D.setClip(new RoundRectangle2D.Float(0.0f, 0.0f, n + this.arc, n2, 2 * this.arc, 2 * this.arc));
                break;
            }
            case RIGHT_OF_DOCKABLE: {
                graphics2D.setClip(new RoundRectangle2D.Float(-this.arc, 0.0f, n + this.arc, n2, 2 * this.arc, 2 * this.arc));
            }
        }
        if (this.orientation.isHorizontal()) {
            graphics2D.fillRect(0, 0, n, n2 / 2);
        } else {
            graphics2D.fillRect(0, 0, n / 2, n2);
        }
        graphics2D.dispose();
    }

    protected void paintChildren(Graphics graphics) {
    }

    public JComponent getComponent() {
        return this;
    }

    public DockElement getElement() {
        return this.dockable;
    }

    public boolean isUsedAsTitle() {
        return false;
    }

    public void addMouseInputListener(MouseInputListener mouseInputListener) {
        this.addMouseListener(mouseInputListener);
        this.addMouseMotionListener(mouseInputListener);
        this.label.addMouseListener(mouseInputListener);
        this.label.addMouseMotionListener(mouseInputListener);
    }

    public void removeMouseInputListener(MouseInputListener mouseInputListener) {
        this.removeMouseListener(mouseInputListener);
        this.removeMouseMotionListener(mouseInputListener);
        this.label.removeMouseListener(mouseInputListener);
        this.label.removeMouseMotionListener(mouseInputListener);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.checkAnimation();
    }

    private void checkAnimation() {
        this.state = 0;
        if (this.parent.getSelectedDockable() == this.dockable) {
            this.state |= 1;
        }
        if (this.mouse) {
            this.state |= 4;
        }
        if (this.focused) {
            this.state |= 3;
        }
        for (BubbleTabColor bubbleTabColor : this.colors) {
            bubbleTabColor.transmit();
        }
        this.updateFonts();
    }

    public void updateFonts() {
        if (this.focused) {
            this.label.setFontModifier((FontModifier)this.fontFocused.value());
        } else if (this.parent.getSelectedDockable() == this.dockable) {
            this.label.setFontModifier((FontModifier)this.fontSelected.value());
        } else {
            this.label.setFontModifier((FontModifier)this.fontUnselected.value());
        }
    }

    public void setIcon(Icon icon) {
        this.label.setIcon(icon);
    }

    public void setText(String string) {
        this.label.setText(string);
    }

    public void stopAnimation() {
        this.animation.stop();
    }

    protected class BubbleTabFont
    extends TabFont {
        public BubbleTabFont(String string, Dockable dockable) {
            super(string, BubbleTab.this.parent.getStation(), dockable);
        }

        protected void changed(FontModifier fontModifier, FontModifier fontModifier2) {
            BubbleTab.this.updateFonts();
        }
    }

    protected class BubbleTabColor
    extends TabColor {
        private int state;
        private String animationId;
        private BubbleColorAnimation animation;

        public BubbleTabColor(int n, String string, String string2, BubbleColorAnimation bubbleColorAnimation, Dockable dockable, Color color) {
            super(string, BubbleTab.this.parent.getStation(), dockable, color);
            this.state = n;
            this.animationId = string2;
            this.animation = bubbleColorAnimation;
        }

        public void transmit() {
            if (BubbleTab.this.getState() == this.state) {
                this.animation.putColor(this.animationId, (Color)this.value());
            }
        }

        protected void changed(Color color, Color color2) {
            if (BubbleTab.this.getState() == this.state) {
                this.animation.putColor(this.animationId, color2);
            }
        }
    }
}

