/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.accept.MultiDockAcceptance;
import bibliothek.gui.dock.action.DefaultDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.ListeningDockAction;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.control.MouseFocusObserver;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockTitleEvent;
import bibliothek.gui.dock.event.DockableAdapter;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.event.FlapDockListener;
import bibliothek.gui.dock.event.FocusVetoListener;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.AbstractDockableStation;
import bibliothek.gui.dock.station.DisplayerCollection;
import bibliothek.gui.dock.station.flap.ButtonPane;
import bibliothek.gui.dock.station.flap.DefaultFlapLayoutManager;
import bibliothek.gui.dock.station.flap.DefaultFlapWindowFactory;
import bibliothek.gui.dock.station.flap.FlapDockHoldToggle;
import bibliothek.gui.dock.station.flap.FlapDockProperty;
import bibliothek.gui.dock.station.flap.FlapDockStationFactory;
import bibliothek.gui.dock.station.flap.FlapDropInfo;
import bibliothek.gui.dock.station.flap.FlapLayoutManager;
import bibliothek.gui.dock.station.flap.FlapWindow;
import bibliothek.gui.dock.station.flap.FlapWindowFactory;
import bibliothek.gui.dock.station.support.CombinerWrapper;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.DisplayerFactoryWrapper;
import bibliothek.gui.dock.station.support.DockableVisibilityManager;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderListItemConverter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.support.StationPaintWrapper;
import bibliothek.gui.dock.themes.basic.BasicButtonTitleFactory;
import bibliothek.gui.dock.title.ControllerTitleFactory;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.gui.dock.util.property.DynamicPropertyFactory;
import bibliothek.util.Path;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlapDockStation
extends AbstractDockableStation {
    public static final String WINDOW_TITLE_ID = "flap window";
    public static final String BUTTON_TITLE_ID = "flap button";
    public static final PropertyKey<FlapLayoutManager> LAYOUT_MANAGER = new PropertyKey<FlapLayoutManager>("flap dock station layout manager", new DynamicPropertyFactory<FlapLayoutManager>(){

        @Override
        public FlapLayoutManager getDefault(PropertyKey<FlapLayoutManager> propertyKey, DockProperties dockProperties) {
            return new DefaultFlapLayoutManager();
        }
    }, true);
    public static final PropertyKey<ButtonContent> BUTTON_CONTENT = new PropertyKey<ButtonContent>("flap dock station button content", new ConstantPropertyFactory<ButtonContent>(ButtonContent.THEME_DEPENDENT), true);
    public static final PropertyKey<Dimension> MINIMUM_SIZE = new PropertyKey<Dimension>("flap dock station empty size", new ConstantPropertyFactory<Dimension>(new Dimension(10, 10)), true);
    public static final PropertyKey<FlapWindowFactory> WINDOW_FACTORY = new PropertyKey<DefaultFlapWindowFactory>("flap dock station window factory", new ConstantPropertyFactory<DefaultFlapWindowFactory>(new DefaultFlapWindowFactory()), true);
    private PropertyValue<FlapLayoutManager> layoutManager = new PropertyValue<FlapLayoutManager>(LAYOUT_MANAGER){

        @Override
        protected void valueChanged(FlapLayoutManager flapLayoutManager, FlapLayoutManager flapLayoutManager2) {
            if (flapLayoutManager != null) {
                flapLayoutManager.uninstall(FlapDockStation.this);
            }
            if (flapLayoutManager2 != null) {
                flapLayoutManager2.install(FlapDockStation.this);
            }
        }
    };
    private PropertyValue<PlaceholderStrategy> placeholderStrategy = new PropertyValue<PlaceholderStrategy>(PlaceholderStrategy.PLACEHOLDER_STRATEGY){

        @Override
        protected void valueChanged(PlaceholderStrategy placeholderStrategy, PlaceholderStrategy placeholderStrategy2) {
            FlapDockStation.this.handles.setStrategy(placeholderStrategy2);
        }
    };
    private PropertyValue<ButtonContent> buttonContent = new PropertyValue<ButtonContent>(BUTTON_CONTENT){

        @Override
        protected void valueChanged(ButtonContent buttonContent, ButtonContent buttonContent2) {
            if (buttonContent != buttonContent2) {
                FlapDockStation.this.recreateTitles();
            }
        }
    };
    private PropertyValue<Dimension> minimumSize = new PropertyValue<Dimension>(MINIMUM_SIZE){

        @Override
        protected void valueChanged(Dimension dimension, Dimension dimension2) {
            FlapDockStation.this.buttonPane.revalidate();
        }
    };
    private PropertyValue<FlapWindowFactory> windowFactory = new PropertyValue<FlapWindowFactory>(WINDOW_FACTORY){

        @Override
        protected void valueChanged(FlapWindowFactory flapWindowFactory, FlapWindowFactory flapWindowFactory2) {
            if (flapWindowFactory != null) {
                flapWindowFactory.uninstall(FlapDockStation.this);
            }
            if (flapWindowFactory2 != null) {
                flapWindowFactory2.install(FlapDockStation.this);
            }
            FlapDockStation.this.updateWindow(FlapDockStation.this.getFrontDockable(), true);
        }
    };
    private Direction direction = Direction.SOUTH;
    private boolean autoDirection = true;
    private FlapWindow window;
    private int windowBorder = 3;
    private int windowMinSize = 25;
    private int defaultWindowSize = 400;
    private Dockable oldFrontDockable;
    private PlaceholderList<DockableHandle> handles = new PlaceholderList();
    private Listener dockableListener = new Listener();
    private ButtonPane buttonPane;
    private DockTitleVersion buttonVersion;
    private DockTitleVersion titleVersion;
    private StationPaintWrapper paint = new StationPaintWrapper();
    private CombinerWrapper combiner = new CombinerWrapper();
    private DisplayerFactoryWrapper displayerFactory = new DisplayerFactoryWrapper();
    private DisplayerCollection displayers;
    private FlapDropInfo dropInfo;
    private ControllerListener controllerListener = new ControllerListener();
    private boolean smallButtons = true;
    private ListeningDockAction holdAction;
    private VisibleListener visibleListener = new VisibleListener();
    private List<FlapDockListener> flapDockListeners = new ArrayList<FlapDockListener>();
    private DockableVisibilityManager visibility;

    public FlapDockStation() {
        this.init();
    }

    protected FlapDockStation(boolean bl) {
        if (bl) {
            this.init();
        }
    }

    protected void init() {
        this.visibility = new DockableVisibilityManager(this.listeners);
        this.buttonPane = this.createButtonPane();
        this.setDirection(Direction.SOUTH);
        this.displayers = new DisplayerCollection(this, this.displayerFactory);
        this.buttonPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (FlapDockStation.this.autoDirection) {
                    FlapDockStation.this.selfSetDirection();
                } else {
                    FlapDockStation.this.updateWindowBounds();
                }
            }
        });
        this.buttonPane.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            public void ancestorMoved(HierarchyEvent hierarchyEvent) {
                if (FlapDockStation.this.autoDirection) {
                    FlapDockStation.this.selfSetDirection();
                } else {
                    FlapDockStation.this.updateWindowBounds();
                }
            }

            public void ancestorResized(HierarchyEvent hierarchyEvent) {
                if (FlapDockStation.this.autoDirection) {
                    FlapDockStation.this.selfSetDirection();
                } else {
                    FlapDockStation.this.updateWindowBounds();
                }
            }
        });
        this.holdAction = this.createHoldAction();
    }

    protected ButtonPane createButtonPane() {
        return new ButtonPane(this);
    }

    protected ListeningDockAction createHoldAction() {
        return new FlapDockHoldToggle(this);
    }

    @Override
    public void setDockParent(DockStation dockStation) {
        if (this.getDockParent() != null) {
            this.getDockParent().removeDockStationListener(this.visibleListener);
        }
        super.setDockParent(dockStation);
        if (dockStation != null) {
            dockStation.addDockStationListener(this.visibleListener);
        }
    }

    @Override
    public void setController(DockController dockController) {
        if (this.getController() != dockController) {
            boolean bl;
            boolean bl2 = bl = this.getController() != null;
            if (bl) {
                this.handles.unbind();
                this.getController().removeDockableFocusListener(this.controllerListener);
                this.getController().getFocusObserver().removeVetoListener(this.controllerListener);
                this.oldFrontDockable = this.getFrontDockable();
                this.setFrontDockable(null);
                for (DockableHandle object2 : this.handles.dockables()) {
                    if (object2 == null) continue;
                    object2.setTitle(null);
                }
                if (this.window != null) {
                    this.window.setDockTitle(null);
                }
                this.titleVersion = null;
                this.buttonVersion = null;
            }
            super.setController(dockController);
            this.placeholderStrategy.setProperties(dockController);
            this.displayers.setController(dockController);
            FlapLayoutManager flapLayoutManager = this.layoutManager.getValue();
            this.layoutManager.setProperties(dockController);
            FlapLayoutManager flapLayoutManager2 = this.layoutManager.getValue();
            if (flapLayoutManager == flapLayoutManager2) {
                if (dockController == null) {
                    if (flapLayoutManager != null) {
                        flapLayoutManager.uninstall(this);
                    }
                } else if (flapLayoutManager2 != null) {
                    flapLayoutManager2.install(this);
                }
            }
            this.buttonContent.setProperties(dockController);
            this.minimumSize.setProperties(dockController);
            if (this.holdAction != null) {
                this.holdAction.setController(dockController);
            }
            if (dockController != null) {
                this.handles.bind();
                this.titleVersion = dockController.getDockTitleManager().getVersion(WINDOW_TITLE_ID, ControllerTitleFactory.INSTANCE);
                this.buttonVersion = dockController.getDockTitleManager().getVersion(BUTTON_TITLE_ID, BasicButtonTitleFactory.FACTORY);
                for (DockableHandle dockableHandle : this.handles.dockables()) {
                    if (dockableHandle == null) continue;
                    dockableHandle.setTitle(this.buttonVersion);
                }
                if (this.window != null) {
                    this.window.setDockTitle(this.titleVersion);
                }
                dockController.addDockableFocusListener(this.controllerListener);
                dockController.getFocusObserver().addVetoListener(this.controllerListener);
                if (this.isStationVisible()) {
                    this.setFrontDockable(this.oldFrontDockable);
                }
            }
            this.windowFactory.setProperties(dockController);
            this.buttonPane.resetTitles();
        }
    }

    @Override
    protected void callDockUiUpdateTheme() throws IOException {
        DockUI.updateTheme(this, new FlapDockStationFactory());
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        if (direction == null) {
            throw new IllegalArgumentException();
        }
        this.direction = direction;
        DockTitle.Orientation orientation = this.orientation(direction);
        for (DockableHandle dockableHandle : this.handles.dockables()) {
            DockTitle dockTitle = dockableHandle.getTitle();
            if (dockTitle == null) continue;
            dockTitle.setOrientation(orientation);
        }
        this.buttonPane.resetTitles();
        this.updateWindowBounds();
        this.buttonPane.revalidate();
    }

    protected DockTitle.Orientation orientation(Direction direction) {
        switch (direction) {
            case NORTH: {
                return DockTitle.Orientation.SOUTH_SIDED;
            }
            case SOUTH: {
                return DockTitle.Orientation.NORTH_SIDED;
            }
            case EAST: {
                return DockTitle.Orientation.WEST_SIDED;
            }
            case WEST: {
                return DockTitle.Orientation.EAST_SIDED;
            }
        }
        return null;
    }

    protected void updateWindowBounds() {
        if (this.window != null) {
            this.window.updateBounds();
        }
    }

    public Dimension getMinimumSize() {
        return this.minimumSize.getValue();
    }

    public void setMinimumSize(Dimension dimension) {
        this.minimumSize.setValue(dimension);
    }

    public DisplayerFactoryWrapper getDisplayerFactory() {
        return this.displayerFactory;
    }

    public DisplayerCollection getDisplayers() {
        return this.displayers;
    }

    public CombinerWrapper getCombiner() {
        return this.combiner;
    }

    public StationPaintWrapper getPaint() {
        return this.paint;
    }

    public Rectangle getExpansionBounds() {
        Component component = this.getComponent();
        return new Rectangle(0, 0, component.getWidth(), component.getHeight());
    }

    public boolean isAutoDirection() {
        return this.autoDirection;
    }

    public void setAutoDirection(boolean bl) {
        this.autoDirection = bl;
        if (bl) {
            this.selfSetDirection();
        }
    }

    public void selfSetDirection() {
        Component component = this.getComponent();
        Point point = new Point(component.getWidth() / 2, component.getHeight() / 2);
        SwingUtilities.convertPointToScreen(point, component);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Direction direction = component.getWidth() > component.getHeight() ? (point.y < dimension.height / 2 ? Direction.SOUTH : Direction.NORTH) : (point.x < dimension.width / 2 ? Direction.EAST : Direction.WEST);
        if (direction != this.direction) {
            this.setDirection(direction);
        } else {
            this.updateWindowBounds();
        }
    }

    @Override
    public Dockable getFrontDockable() {
        if (this.window == null) {
            return null;
        }
        return this.window.getDockable();
    }

    @Override
    public void setFrontDockable(Dockable dockable) {
        Dockable dockable2 = this.getFrontDockable();
        if (dockable2 == dockable) {
            return;
        }
        this.updateWindow(dockable, false);
        if (dockable2 != null && this.getController() != null) {
            DockTitle[] dockTitleArray = dockable2.listBoundTitles();
            boolean bl = this.getController().isFocused(dockable2);
            for (DockTitle dockTitle : dockTitleArray) {
                this.changed(dockable2, dockTitle, bl);
            }
        }
        if (this.window != null) {
            if (this.window.getDockable() == null) {
                this.window.setWindowVisible(false);
            } else {
                this.window.repaint();
            }
        }
        this.visibility.fire();
        this.listeners.fireDockableSelected(dockable2, dockable);
    }

    private void updateWindow(Dockable dockable, boolean bl) {
        if (dockable == null) {
            if (this.window != null) {
                this.window.setDockable(null);
                if (bl) {
                    this.setFlapWindow(null);
                }
            }
        } else {
            Window window = SwingUtilities.getWindowAncestor(this.getComponent());
            if (this.window == null || bl || !this.windowFactory.getValue().isValid(this.window, this)) {
                FlapWindow flapWindow;
                if (this.window != null) {
                    this.window.setDockable(null);
                }
                if ((flapWindow = this.createFlapWindow(this.buttonPane)) != null) {
                    this.setFlapWindow(flapWindow);
                }
            }
            if (this.window != null && window != null) {
                this.window.setDockable(dockable);
                if (window.isVisible()) {
                    this.window.setWindowVisible(true);
                }
                this.updateWindowBounds();
            }
        }
    }

    protected FlapWindow createFlapWindow(ButtonPane buttonPane) {
        FlapWindow flapWindow = this.windowFactory.getValue().create(this, buttonPane);
        if (flapWindow != null) {
            flapWindow.setDockTitle(this.titleVersion);
        }
        return flapWindow;
    }

    public boolean isHold(Dockable dockable) {
        FlapLayoutManager flapLayoutManager = this.layoutManager.getValue();
        if (flapLayoutManager == null) {
            return false;
        }
        return flapLayoutManager.isHold(this, dockable);
    }

    public void setHold(Dockable dockable, boolean bl) {
        FlapLayoutManager flapLayoutManager = this.layoutManager.getValue();
        if (flapLayoutManager != null) {
            boolean bl2 = flapLayoutManager.isHold(this, dockable);
            flapLayoutManager.setHold(this, dockable, bl);
            bl = flapLayoutManager.isHold(this, dockable);
            if (bl2 != bl) {
                this.updateHold(dockable);
            }
        }
    }

    public void updateHold(Dockable dockable) {
        FlapLayoutManager flapLayoutManager = this.layoutManager.getValue();
        if (flapLayoutManager != null) {
            boolean bl = flapLayoutManager.isHold(this, dockable);
            this.fireHoldChanged(dockable, bl);
            if (!bl && this.getController() != null && this.getFrontDockable() == dockable && !this.getController().isFocused(dockable)) {
                this.setFrontDockable(null);
            }
        }
    }

    public boolean isSmallButtons() {
        return this.smallButtons;
    }

    public void setSmallButtons(boolean bl) {
        this.smallButtons = bl;
    }

    public DockTitleVersion getTitleVersion() {
        return this.titleVersion;
    }

    public DockTitleVersion getButtonVersion() {
        return this.buttonVersion;
    }

    public int getWindowBorder() {
        return this.windowBorder;
    }

    public void setWindowBorder(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Border must not be less than 0");
        }
        this.windowBorder = n;
        this.updateWindowBounds();
    }

    public int getWindowMinSize() {
        return this.windowMinSize;
    }

    public void setWindowMinSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Min size must not be smaller than 0");
        }
        this.windowMinSize = n;
        this.updateWindowBounds();
    }

    public int getWindowSize(Dockable dockable) {
        FlapLayoutManager flapLayoutManager = this.layoutManager.getValue();
        if (flapLayoutManager == null) {
            return 0;
        }
        return flapLayoutManager.getSize(this, dockable);
    }

    public void setWindowSize(Dockable dockable, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Size must at least be 0");
        }
        FlapLayoutManager flapLayoutManager = this.layoutManager.getValue();
        if (flapLayoutManager != null) {
            flapLayoutManager.setSize(this, dockable, n);
            this.updateWindowSize(dockable);
        }
    }

    public void updateWindowSize(Dockable dockable) {
        if (this.getFrontDockable() == dockable) {
            this.updateWindowBounds();
        }
    }

    public void setDefaultWindowSize(int n) {
        this.defaultWindowSize = n;
    }

    public int getDefaultWindowSize() {
        return this.defaultWindowSize;
    }

    public void setFlapLayoutManager(FlapLayoutManager flapLayoutManager) {
        this.layoutManager.setValue(flapLayoutManager);
    }

    public FlapLayoutManager getFlapLayoutManager() {
        return this.layoutManager.getOwnValue();
    }

    public PlaceholderStrategy getPlaceholderStrategy() {
        return this.placeholderStrategy.getValue();
    }

    public void setPlaceholderStrategy(PlaceholderStrategy placeholderStrategy) {
        this.placeholderStrategy.setValue(placeholderStrategy);
    }

    public void addFlapDockStationListener(FlapDockListener flapDockListener) {
        this.flapDockListeners.add(flapDockListener);
    }

    public void removeFlapDockStationListener(FlapDockListener flapDockListener) {
        this.flapDockListeners.remove(flapDockListener);
    }

    protected void fireHoldChanged(Dockable dockable, boolean bl) {
        for (FlapDockListener flapDockListener : this.flapDockListeners.toArray(new FlapDockListener[this.flapDockListeners.size()])) {
            flapDockListener.holdChanged(this, dockable, bl);
        }
    }

    @Override
    public DefaultDockActionSource getDirectActionOffers(Dockable dockable) {
        if (this.holdAction == null) {
            return null;
        }
        DefaultDockActionSource defaultDockActionSource = new DefaultDockActionSource(new LocationHint(LocationHint.DIRECT_ACTION, LocationHint.LITTLE_LEFT), new DockAction[0]);
        defaultDockActionSource.add(this.holdAction);
        return defaultDockActionSource;
    }

    @Override
    public void changed(Dockable dockable, DockTitle dockTitle, boolean bl) {
        DockTitleEvent dockTitleEvent = new DockTitleEvent(this, dockable, bl);
        dockTitleEvent.setPreferred(dockable == this.getFrontDockable());
        dockTitle.changed(dockTitleEvent);
    }

    @Override
    public Rectangle getStationBounds() {
        Point point = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point, this.getComponent());
        Rectangle rectangle = new Rectangle(point.x, point.y, this.getComponent().getWidth(), this.getComponent().getHeight());
        if (this.window != null && this.window.isWindowVisible()) {
            Rectangle rectangle2 = this.window.getWindowBounds();
            rectangle = SwingUtilities.computeUnion(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, rectangle);
        }
        return rectangle;
    }

    private void setDropInfo(FlapDropInfo flapDropInfo) {
        this.dropInfo = flapDropInfo;
        if (this.window != null) {
            this.window.setDropInfo(flapDropInfo);
        }
        if (this.buttonPane != null) {
            this.buttonPane.setDropInfo(flapDropInfo);
        }
    }

    private void setFlapWindow(FlapWindow flapWindow) {
        if (this.window != null) {
            this.window.destory();
        }
        this.window = flapWindow;
        if (flapWindow != null) {
            flapWindow.setDropInfo(this.dropInfo);
        }
    }

    public boolean isFlapWindow(FlapWindow flapWindow) {
        return this.window == flapWindow;
    }

    @Override
    public PlaceholderMap getPlaceholders() {
        return this.handles.toMap();
    }

    @Override
    public void setPlaceholders(PlaceholderMap placeholderMap) {
        if (this.getDockableCount() > 0) {
            throw new IllegalStateException("only allowed if there are not children present");
        }
        try {
            PlaceholderList placeholderList = new PlaceholderList(placeholderMap);
            if (this.getController() != null) {
                this.handles.setStrategy(null);
                this.handles.unbind();
                this.handles = placeholderList;
                this.handles.bind();
                this.handles.setStrategy(this.getPlaceholderStrategy());
            } else {
                this.handles = placeholderList;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public PlaceholderMap getPlaceholders(final Map<Dockable, Integer> map) {
        final PlaceholderStrategy placeholderStrategy = this.getPlaceholderStrategy();
        return this.handles.toMap((PlaceholderListItemConverter<DockableHandle>)new PlaceholderListItemAdapter<DockableHandle>(){

            @Override
            public ConvertedPlaceholderListItem convert(int n, DockableHandle dockableHandle) {
                Path path;
                ConvertedPlaceholderListItem convertedPlaceholderListItem = new ConvertedPlaceholderListItem();
                convertedPlaceholderListItem.putInt("id", (Integer)map.get(dockableHandle.getDockable()));
                convertedPlaceholderListItem.putInt("index", n);
                convertedPlaceholderListItem.putBoolean("hold", FlapDockStation.this.isHold(dockableHandle.getDockable()));
                convertedPlaceholderListItem.putInt("size", FlapDockStation.this.getWindowSize(dockableHandle.getDockable()));
                if (placeholderStrategy != null && (path = placeholderStrategy.getPlaceholderFor(dockableHandle.getDockable())) != null) {
                    convertedPlaceholderListItem.putString("placeholder", path.toString());
                    convertedPlaceholderListItem.setPlaceholder(path);
                }
                return convertedPlaceholderListItem;
            }
        });
    }

    public void setPlaceholders(PlaceholderMap placeholderMap, final Map<Integer, Dockable> map) {
        if (this.getDockableCount() > 0) {
            throw new IllegalStateException("must not have any children");
        }
        PlaceholderList<DockableHandle> placeholderList = new PlaceholderList<DockableHandle>(placeholderMap, new PlaceholderListItemAdapter<DockableHandle>(){

            @Override
            public DockableHandle convert(ConvertedPlaceholderListItem convertedPlaceholderListItem) {
                int n = convertedPlaceholderListItem.getInt("id");
                Dockable dockable = (Dockable)map.get(n);
                if (dockable != null) {
                    boolean bl = convertedPlaceholderListItem.getBoolean("hold");
                    int n2 = convertedPlaceholderListItem.getInt("size");
                    FlapDockStation.this.listeners.fireDockableAdding(dockable);
                    DockableHandle dockableHandle = FlapDockStation.this.link(dockable);
                    FlapDockStation.this.setHold(dockable, bl);
                    FlapDockStation.this.setWindowSize(dockable, n2);
                    return dockableHandle;
                }
                return null;
            }

            @Override
            public void added(DockableHandle dockableHandle) {
                dockableHandle.getDockable().setDockParent(FlapDockStation.this);
                FlapDockStation.this.listeners.fireDockableAdded(dockableHandle.getDockable());
            }
        });
        if (this.getController() != null) {
            this.handles.setStrategy(null);
            this.handles.unbind();
            this.handles = placeholderList;
            this.handles.bind();
            this.handles.setStrategy(this.getPlaceholderStrategy());
        } else {
            this.handles = placeholderList;
        }
        this.buttonPane.resetTitles();
    }

    @Override
    public boolean prepareDrop(int n, int n2, int n3, int n4, boolean bl, Dockable dockable) {
        Object object;
        Object object2;
        if (SwingUtilities.isDescendingFrom(this.getComponent(), dockable.getComponent())) {
            this.setDropInfo(null);
            return false;
        }
        Point point = new Point(n, n2);
        SwingUtilities.convertPointFromScreen(point, this.buttonPane);
        boolean bl2 = this.buttonPane.titleContains(point.x, point.y);
        boolean bl3 = false;
        MultiDockAcceptance multiDockAcceptance = this.getController().getAcceptance();
        if (!bl2 && this.window != null && this.window.isWindowVisible() && (object2 = this.window.getDockTitle()) != null) {
            object = object2.getComponent();
            Point point2 = new Point(n, n2);
            SwingUtilities.convertPointFromScreen(point2, (Component)object);
            Dockable dockable2 = this.window.getDockable();
            boolean bl4 = bl3 = ((Component)object).contains(point2) && dockable.accept(this, dockable2) && dockable2.accept(this, dockable) && multiDockAcceptance.accept(this, dockable2, dockable);
        }
        if (!bl2 && !bl3 && (object2 = this.getDockParent()) != null && bl && object2.isInOverrideZone(n, n2, this, dockable)) {
            return false;
        }
        if (this.window != null && this.window.isWindowVisible() && !bl3) {
            object2 = new Point(n, n2);
            object = this.window.getDockable();
            boolean bl5 = bl3 = this.window.containsScreenPoint((Point)object2) && dockable.accept(this, (Dockable)object) && object.accept(this, dockable) && multiDockAcceptance.accept(this, (Dockable)object, dockable);
        }
        if (bl3 && dockable == this.getFrontDockable()) {
            return false;
        }
        object2 = null;
        if (bl3) {
            object2 = new FlapDropInfo(dockable);
            ((FlapDropInfo)object2).setCombine(this.getFrontDockable());
        } else if (dockable.accept(this) && this.accept(dockable) && multiDockAcceptance.accept(this, dockable)) {
            object2 = new FlapDropInfo(dockable);
            ((FlapDropInfo)object2).setIndex(this.buttonPane.indexAt(point.x, point.y));
        }
        this.setDropInfo((FlapDropInfo)object2);
        return object2 != null;
    }

    @Override
    public void drop() {
        if (this.dropInfo.getCombine() != null) {
            this.combine(this.dropInfo.getCombine(), this.dropInfo.getDockable());
        } else {
            this.add(this.dropInfo.getDockable(), this.dropInfo.getIndex());
        }
    }

    @Override
    public void drop(Dockable dockable) {
        this.add(dockable);
    }

    @Override
    public boolean drop(Dockable dockable, DockableProperty dockableProperty) {
        if (dockableProperty instanceof FlapDockProperty) {
            return this.drop(dockable, (FlapDockProperty)dockableProperty);
        }
        return false;
    }

    public boolean drop(Dockable dockable, FlapDockProperty flapDockProperty) {
        DockStation dockStation;
        DockableHandle dockableHandle;
        DockUtilities.ensureTreeValidity(this, dockable);
        boolean bl = false;
        Path path = flapDockProperty.getPlaceholder();
        DockableProperty dockableProperty = flapDockProperty.getSuccessor();
        int n = flapDockProperty.getIndex();
        boolean bl2 = this.acceptable(dockable);
        if (path != null && dockableProperty != null) {
            DockStation dockStation2;
            dockableHandle = this.handles.getDockableAt(path);
            if (dockableHandle != null && (dockStation2 = dockableHandle.getDockable().asDockStation()) != null && dockStation2.drop(dockable, dockableProperty)) {
                bl = true;
                this.handles.removeAll(path);
            }
        } else if (path != null) {
            n = this.handles.getDockableIndex(path);
            if (n == -1) {
                n = flapDockProperty.getIndex();
            } else if (bl2) {
                this.listeners.fireDockableAdding(dockable);
                dockableHandle = this.link(dockable);
                this.handles.put(path, dockableHandle);
                dockable.setDockParent(this);
                this.listeners.fireDockableAdded(dockable);
                bl = true;
            }
        }
        if (!bl && n >= this.getDockableCount() && bl2) {
            this.add(dockable);
            this.setHold(dockable, flapDockProperty.isHolding());
            int n2 = flapDockProperty.getSize();
            if (n2 >= this.getWindowMinSize()) {
                this.setWindowSize(dockable, n2);
            }
            bl = true;
        }
        if (!bl && dockableProperty != null && (dockStation = this.getDockable(n).asDockStation()) != null && dockStation.drop(dockable, dockableProperty)) {
            bl = true;
        }
        if (!bl && bl2) {
            this.add(dockable, n);
            this.setHold(dockable, flapDockProperty.isHolding());
            int n3 = flapDockProperty.getSize();
            if (n3 >= this.getWindowMinSize()) {
                this.setWindowSize(dockable, n3);
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public DockableProperty getDockableProperty(Dockable dockable, Dockable dockable2) {
        int n = this.indexOf(dockable);
        boolean bl = this.isHold(dockable);
        int n2 = this.getWindowSize(dockable);
        PlaceholderStrategy placeholderStrategy = this.getPlaceholderStrategy();
        Path path = null;
        if (placeholderStrategy != null && (path = placeholderStrategy.getPlaceholderFor(dockable2 == null ? dockable : dockable2)) != null) {
            this.handles.dockables().addPlaceholder(n, path);
        }
        return new FlapDockProperty(n, bl, n2, path);
    }

    @Override
    public boolean prepareMove(int n, int n2, int n3, int n4, boolean bl, Dockable dockable) {
        return this.prepareDrop(n, n2, n3, n4, bl, dockable);
    }

    @Override
    public void move() {
        if (this.dropInfo.getCombine() != null) {
            this.remove(this.dropInfo.getDockable());
            this.combine(this.dropInfo.getCombine(), this.dropInfo.getDockable());
        } else {
            int n = this.indexOf(this.dropInfo.getDockable());
            if (n < this.dropInfo.getIndex()) {
                this.dropInfo.setIndex(this.dropInfo.getIndex() - 1);
            }
            this.handles.dockables().move(n, this.dropInfo.getIndex());
            this.buttonPane.resetTitles();
        }
    }

    @Override
    public void move(Dockable dockable, DockableProperty dockableProperty) {
        if (dockableProperty instanceof FlapDockProperty) {
            int n = this.indexOf(dockable);
            if (n < 0) {
                throw new IllegalArgumentException("dockable is not child of this station");
            }
            int n2 = ((FlapDockProperty)dockableProperty).getIndex();
            n2 = Math.min(n2, this.handles.dockables().size() - 1);
            if ((n2 = Math.max(0, n2)) != n) {
                this.handles.dockables().move(n, n2);
                this.buttonPane.resetTitles();
            }
        }
    }

    @Override
    public void draw() {
        if (this.dropInfo != null) {
            this.dropInfo.setDraw(true);
        }
        this.buttonPane.repaint();
        if (this.window != null) {
            this.window.repaint();
        }
    }

    @Override
    public void forget() {
        this.setDropInfo(null);
        this.buttonPane.repaint();
    }

    @Override
    public <D extends Dockable & DockStation> boolean isInOverrideZone(int n, int n2, D d, Dockable dockable) {
        Point point = new Point(n, n2);
        SwingUtilities.convertPointFromScreen(point, this.buttonPane);
        if (this.buttonPane.contains(point) && this.accept(dockable) && dockable.accept(this)) {
            return true;
        }
        DockStation dockStation = this.getDockParent();
        if (dockStation != null) {
            return dockStation.isInOverrideZone(n, n2, d, dockable);
        }
        return false;
    }

    @Override
    public boolean canDrag(Dockable dockable) {
        return true;
    }

    @Override
    public void drag(Dockable dockable) {
        if (dockable.getDockParent() != this) {
            throw new IllegalArgumentException("The dockable can't be dragged, it is not child of this station");
        }
        this.remove(dockable);
    }

    @Override
    public String getFactoryID() {
        return "flap dock";
    }

    @Override
    public Component getComponent() {
        return this.buttonPane;
    }

    @Override
    public int getDockableCount() {
        return this.handles.dockables().size();
    }

    @Override
    public Dockable getDockable(int n) {
        return this.handles.dockables().get(n).getDockable();
    }

    public DockTitle getButton(int n) {
        return this.handles.dockables().get(n).getTitle();
    }

    @Override
    public boolean isVisible(Dockable dockable) {
        return this.isStationVisible() && this.getFrontDockable() == dockable;
    }

    protected void recreateTitles() {
        for (DockableHandle dockableHandle : this.handles.dockables()) {
            dockableHandle.setTitle(this.buttonVersion);
        }
    }

    public void remove(Dockable dockable) {
        int n = this.indexOf(dockable);
        if (n >= 0) {
            this.remove(n);
        }
    }

    public void remove(int n) {
        Dockable dockable = this.getDockable(n);
        if (this.getFrontDockable() == dockable) {
            this.setFrontDockable(null);
        }
        if (this.oldFrontDockable == dockable) {
            this.oldFrontDockable = null;
        }
        this.listeners.fireDockableRemoving(dockable);
        dockable.setDockParent(null);
        DockableHandle dockableHandle = this.handles.dockables().get(n);
        this.handles.remove(n);
        dockableHandle.setTitle(null);
        dockable.removeDockableListener(this.dockableListener);
        this.buttonPane.resetTitles();
        this.listeners.fireDockableRemoved(dockable);
    }

    public void add(Dockable dockable) {
        this.add(dockable, this.getDockableCount());
    }

    public void add(Dockable dockable, int n) {
        DockUtilities.ensureTreeValidity(this, dockable);
        this.listeners.fireDockableAdding(dockable);
        DockableHandle dockableHandle = this.link(dockable);
        this.handles.dockables().add(n, dockableHandle);
        dockable.setDockParent(this);
        this.buttonPane.resetTitles();
        this.listeners.fireDockableAdded(dockable);
    }

    private DockableHandle link(Dockable dockable) {
        DockableHandle dockableHandle = new DockableHandle(dockable);
        dockableHandle.setTitle(this.buttonVersion);
        dockable.addDockableListener(this.dockableListener);
        return dockableHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean combine(Dockable dockable, Dockable dockable2) {
        DockController dockController = this.getController();
        try {
            int n;
            if (dockController != null) {
                dockController.freezeLayout();
            }
            if ((n = this.indexOf(dockable)) < 0) {
                throw new IllegalArgumentException("Child must be a child of this station");
            }
            if (dockable2.getDockParent() != null) {
                dockable2.getDockParent().drag(dockable2);
            }
            boolean bl = this.isHold(dockable);
            int n2 = this.handles.levelToBase(n, PlaceholderList.Level.DOCKABLE);
            PlaceholderList.Item item = this.handles.list().get(n2);
            this.remove(n);
            int n3 = this.indexOf(dockable2);
            if (n3 >= 0) {
                this.remove(n3);
                if (n3 < n) {
                    --n;
                }
            }
            n = Math.min(n, this.getDockableCount());
            Dockable dockable3 = this.combiner.combine(dockable, dockable2, this, item.getPlaceholderMap());
            this.add(dockable3, n);
            PlaceholderList.Item item2 = this.handles.list().get(n2);
            item2.setPlaceholderSet(item2.getPlaceholderSet());
            this.setHold(dockable3, bl);
            boolean bl2 = true;
            return bl2;
        }
        finally {
            if (dockController != null) {
                dockController.meltLayout();
            }
        }
    }

    @Override
    public boolean canReplace(Dockable dockable, Dockable dockable2) {
        return true;
    }

    @Override
    public void replace(DockStation dockStation, Dockable dockable) {
        this.replace(dockStation.asDockable(), dockable, true);
    }

    @Override
    public void replace(Dockable dockable, Dockable dockable2) {
        this.replace(dockable, dockable2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replace(Dockable dockable, Dockable dockable2, boolean bl) {
        DockController dockController = this.getController();
        try {
            int n;
            if (dockController != null) {
                dockController.freezeLayout();
            }
            if ((n = this.indexOf(dockable)) < 0) {
                throw new IllegalArgumentException("Child must be a child of this station");
            }
            boolean bl2 = this.isHold(dockable);
            boolean bl3 = this.getFrontDockable() == dockable;
            int n2 = this.handles.levelToBase(n, PlaceholderList.Level.DOCKABLE);
            PlaceholderList.Item item = this.handles.list().get(n2);
            this.remove(n);
            this.add(dockable2, n);
            PlaceholderList.Item item2 = this.handles.list().get(n2);
            if (bl) {
                item2.setPlaceholderMap(dockable.asDockStation().getPlaceholders());
            } else {
                item2.setPlaceholderMap(item.getPlaceholderMap());
            }
            item2.setPlaceholderSet(item.getPlaceholderSet());
            this.setHold(dockable2, bl2);
            if (bl3) {
                this.setFrontDockable(dockable2);
            }
        }
        finally {
            if (dockController != null) {
                dockController.meltLayout();
            }
        }
    }

    public int indexOf(Dockable dockable) {
        PlaceholderList.Filter<DockableHandle> filter = this.handles.dockables();
        int n = 0;
        for (DockableHandle dockableHandle : filter) {
            if (dockableHandle.getDockable() == dockable) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private class ButtonListener
    extends MouseInputAdapter {
        private Dockable dockable;

        public ButtonListener(Dockable dockable) {
            this.dockable = dockable;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.dockable.getDockParent() == FlapDockStation.this && mouseEvent.getButton() == 1 && (mouseEvent.getModifiersEx() & 0x1C00) == 0) {
                int n = FlapDockStation.this.indexOf(this.dockable);
                if (n < 0) {
                    return;
                }
                DockableHandle dockableHandle = (DockableHandle)FlapDockStation.this.handles.dockables().get(n);
                DockTitle dockTitle = dockableHandle.getTitle();
                if (FlapDockStation.this.getFrontDockable() == this.dockable && dockTitle.isActive()) {
                    FlapDockStation.this.getController().setFocusedDockable(FlapDockStation.this, true);
                    FlapDockStation.this.setFrontDockable(null);
                } else {
                    FlapDockStation.this.getController().setFocusedDockable(this.dockable, true);
                }
            }
        }
    }

    private class ControllerListener
    implements FocusVetoListener,
    DockableFocusListener {
        private ControllerListener() {
        }

        public FocusVetoListener.FocusVeto vetoFocus(MouseFocusObserver mouseFocusObserver, Dockable dockable) {
            return FocusVetoListener.FocusVeto.NONE;
        }

        public FocusVetoListener.FocusVeto vetoFocus(MouseFocusObserver mouseFocusObserver, DockTitle dockTitle) {
            for (DockableHandle dockableHandle : FlapDockStation.this.handles.dockables()) {
                if (dockableHandle.getTitle() != dockTitle) continue;
                return FocusVetoListener.FocusVeto.VETO_NO_CONSUME;
            }
            return FocusVetoListener.FocusVeto.NONE;
        }

        public void dockableFocused(DockableFocusEvent dockableFocusEvent) {
            Dockable dockable = FlapDockStation.this.getFrontDockable();
            if (FlapDockStation.this.isStationVisible()) {
                if (dockable == null || dockable != null && FlapDockStation.this.isHold(dockable)) {
                    return;
                }
                DockController dockController = dockableFocusEvent.getController();
                Dockable dockable2 = dockableFocusEvent.getNewFocusOwner();
                if (dockController.isFocused(FlapDockStation.this)) {
                    return;
                }
                if (dockable2 == null || !DockUtilities.isAncestor(FlapDockStation.this, dockable2)) {
                    FlapDockStation.this.setFrontDockable(null);
                }
            }
        }
    }

    private class DockableHandle
    implements PlaceholderListItem {
        private Dockable dockable;
        private DockTitleRequest title;
        private ButtonListener buttonListener;

        public DockableHandle(Dockable dockable) {
            this.dockable = dockable;
            this.buttonListener = new ButtonListener(dockable);
        }

        public Dockable getDockable() {
            return this.dockable;
        }

        public Dockable asDockable() {
            return this.getDockable();
        }

        public DockTitle getTitle() {
            if (this.title == null) {
                return null;
            }
            return this.title.getAnswer();
        }

        public void setTitle(DockTitleVersion dockTitleVersion) {
            if (this.title != null) {
                DockTitle dockTitle = this.title.getAnswer();
                if (dockTitle != null) {
                    dockTitle.removeMouseInputListener(this.buttonListener);
                    this.dockable.unbind(dockTitle);
                    FlapDockStation.this.buttonPane.resetTitles();
                }
                this.title.uninstall();
                this.title = null;
            }
            if (dockTitleVersion != null) {
                this.title = new DockTitleRequest(FlapDockStation.this, this.dockable, dockTitleVersion){

                    protected void answer(DockTitle dockTitle, DockTitle dockTitle2) {
                        if (dockTitle != null) {
                            dockTitle.removeMouseInputListener(DockableHandle.this.buttonListener);
                            DockableHandle.this.dockable.unbind(dockTitle);
                        }
                        if (dockTitle2 != null) {
                            dockTitle2.addMouseInputListener(DockableHandle.this.buttonListener);
                            dockTitle2.setOrientation(FlapDockStation.this.orientation(FlapDockStation.this.direction));
                            DockableHandle.this.dockable.bind(dockTitle2);
                        }
                        FlapDockStation.this.buttonPane.resetTitles();
                    }
                };
                this.title.install();
                this.title.request();
            }
        }
    }

    private class Listener
    extends DockableAdapter {
        private Listener() {
        }

        public void titleExchanged(Dockable dockable, DockTitle dockTitle) {
            int n = FlapDockStation.this.indexOf(dockable);
            if (n < 0) {
                return;
            }
            DockableHandle dockableHandle = (DockableHandle)FlapDockStation.this.handles.dockables().get(n);
            if (dockableHandle.getTitle() == dockTitle) {
                dockableHandle.setTitle(FlapDockStation.this.buttonVersion);
            }
        }
    }

    private class VisibleListener
    extends DockStationAdapter {
        private boolean visible = false;

        private VisibleListener() {
        }

        public void dockableVisibiltySet(DockStation dockStation, Dockable dockable, boolean bl) {
            if (bl != this.visible && dockable == FlapDockStation.this) {
                this.visible = bl;
                if (bl) {
                    if (FlapDockStation.this.oldFrontDockable != null) {
                        FlapDockStation.this.setFrontDockable(FlapDockStation.this.oldFrontDockable);
                    }
                } else {
                    FlapDockStation.this.oldFrontDockable = FlapDockStation.this.getFrontDockable();
                    FlapDockStation.this.setFrontDockable(null);
                    if (!FlapDockStation.this.isHold(FlapDockStation.this.oldFrontDockable)) {
                        FlapDockStation.this.oldFrontDockable = null;
                    }
                }
                FlapDockStation.this.visibility.fire();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ButtonContent {
        THEME_DEPENDENT,
        ICON_ONLY,
        TEXT_ONLY,
        ICON_AND_TEXT_ONLY,
        ICON_THEN_TEXT_ONLY,
        TEXT_THEN_ICON_ONLY,
        ICON_ACTIONS,
        TEXT_ACTIONS,
        ICON_AND_TEXT_ACTIONS,
        ICON_THEN_TEXT_ACTIONS,
        TEXT_THEN_ICON_ACTIONS;


        public boolean showActions(boolean bl) {
            switch (this) {
                case ICON_AND_TEXT_ONLY: 
                case ICON_ONLY: 
                case ICON_THEN_TEXT_ONLY: 
                case TEXT_ONLY: 
                case TEXT_THEN_ICON_ONLY: {
                    return false;
                }
                case ICON_ACTIONS: 
                case ICON_AND_TEXT_ACTIONS: 
                case ICON_THEN_TEXT_ACTIONS: 
                case TEXT_ACTIONS: 
                case TEXT_THEN_ICON_ACTIONS: {
                    return true;
                }
            }
            return bl;
        }

        public boolean showIcon(boolean bl, boolean bl2) {
            switch (this) {
                case ICON_AND_TEXT_ONLY: 
                case ICON_ONLY: 
                case ICON_THEN_TEXT_ONLY: 
                case ICON_ACTIONS: 
                case ICON_AND_TEXT_ACTIONS: 
                case ICON_THEN_TEXT_ACTIONS: {
                    return true;
                }
                case TEXT_ONLY: 
                case TEXT_ACTIONS: {
                    return false;
                }
                case TEXT_THEN_ICON_ONLY: 
                case TEXT_THEN_ICON_ACTIONS: {
                    return !bl;
                }
            }
            return bl2;
        }

        public boolean showText(boolean bl, boolean bl2) {
            switch (this) {
                case ICON_AND_TEXT_ONLY: 
                case TEXT_ONLY: 
                case TEXT_THEN_ICON_ONLY: 
                case ICON_AND_TEXT_ACTIONS: 
                case TEXT_ACTIONS: 
                case TEXT_THEN_ICON_ACTIONS: {
                    return true;
                }
                case ICON_ONLY: 
                case ICON_ACTIONS: {
                    return false;
                }
                case ICON_THEN_TEXT_ONLY: 
                case ICON_THEN_TEXT_ACTIONS: {
                    return !bl;
                }
            }
            return bl2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        NORTH,
        WEST,
        SOUTH,
        EAST;

    }
}

