/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.accept.MultiDockAcceptance;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.SplitDockAccess;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.split.SplitNodeVisitor;
import bibliothek.gui.dock.station.split.SplitTreeFactory;
import bibliothek.gui.dock.station.split.VisibleSplitNode;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.Path;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Leaf
extends VisibleSplitNode {
    private StationChildHandle handle;

    public Leaf(SplitDockAccess splitDockAccess) {
        super(splitDockAccess, -1L);
    }

    public Leaf(SplitDockAccess splitDockAccess, long l) {
        super(splitDockAccess, l);
    }

    public void setHandle(StationChildHandle stationChildHandle) {
        this.handle = stationChildHandle;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.handle == null) {
            return new Dimension(0, 0);
        }
        DockableDisplayer dockableDisplayer = this.handle.getDisplayer();
        if (dockableDisplayer == null) {
            return new Dimension(0, 0);
        }
        return dockableDisplayer.getComponent().getMinimumSize();
    }

    @Override
    public int getChildLocation(SplitNode splitNode) {
        return -1;
    }

    @Override
    public void setChild(SplitNode splitNode, int n) {
        throw new IllegalStateException("can't add children to a leaf");
    }

    public void setDockable(Dockable dockable, boolean bl) {
        this.setDockable(dockable, bl, true, false);
    }

    public void setDockable(Dockable dockable, boolean bl, boolean bl2, boolean bl3) {
        if (this.handle != null) {
            if (bl2) {
                this.getAccess().getPlaceholderSet().set((SplitNode)this, this.handle.getDockable(), new SplitNode[0]);
            }
            if (bl3) {
                DockStation dockStation = this.handle.getDockable().asDockStation();
                if (dockStation == null) {
                    throw new IllegalStateException("no station as child but storePlaceholderMap is set");
                }
                this.setPlaceholderMap(dockStation.getPlaceholders());
            }
            this.getAccess().removeHandle(this.handle, bl);
            this.handle = null;
        }
        if (dockable != null) {
            this.handle = this.getAccess().newHandle(dockable);
            if (bl2) {
                this.getAccess().getPlaceholderSet().set(null, dockable, new SplitNode[0]);
            }
            this.getAccess().addHandle(this.handle, bl);
        }
        this.treeChanged();
    }

    public Dockable getDockable() {
        return this.handle == null ? null : this.handle.getDockable();
    }

    public DockableDisplayer getDisplayer() {
        return this.handle == null ? null : this.handle.getDisplayer();
    }

    public StationChildHandle getDockableHandle() {
        return this.handle;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public SplitNode getVisible() {
        return this;
    }

    @Override
    public boolean isOfUse() {
        if (!this.getAccess().isTreeAutoCleanupEnabled()) {
            return true;
        }
        return this.handle != null || this.hasPlaceholders();
    }

    public void placehold(boolean bl) {
        Object object;
        Dockable dockable = this.getDockable();
        if (dockable != null) {
            DockStation dockStation;
            object = this.getAccess();
            PlaceholderStrategy placeholderStrategy = object.getOwner().getPlaceholderStrategy();
            if (placeholderStrategy != null) {
                this.updatePlaceholders(dockable, bl, placeholderStrategy);
            }
            if ((dockStation = dockable.asDockStation()) != null && bl) {
                this.setPlaceholderMap(dockStation.getPlaceholders());
            }
        }
        if (this.hasPlaceholders()) {
            object = this.createPlaceholder(this.getId());
            ((SplitNode)object).setPlaceholders(this.getPlaceholders());
            this.movePlaceholderMap((SplitNode)object);
            this.replace((SplitNode)object);
        } else {
            this.delete(true);
        }
    }

    private void updatePlaceholders(Dockable dockable, boolean bl, PlaceholderStrategy placeholderStrategy) {
        DockStation dockStation;
        Path path = placeholderStrategy.getPlaceholderFor(dockable);
        if (path != null) {
            if (!bl) {
                this.getAccess().getPlaceholderSet().set(null, path, new SplitNode[0]);
            } else {
                this.getAccess().getPlaceholderSet().set((SplitNode)this, path, new SplitNode[0]);
            }
        }
        if ((dockStation = dockable.asDockStation()) != null) {
            int n = dockStation.getDockableCount();
            for (int i = 0; i < n; ++i) {
                this.updatePlaceholders(dockStation.getDockable(i), bl, placeholderStrategy);
            }
        }
    }

    @Override
    public void updateBounds(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        super.updateBounds(d, d2, d3, d4, d5, d6, bl);
        DockableDisplayer dockableDisplayer = this.getDisplayer();
        if (bl && dockableDisplayer != null && dockableDisplayer != this.getAccess().getFullScreenDockable()) {
            dockableDisplayer.getComponent().setBounds(this.getBounds());
        }
    }

    @Override
    public PutInfo getPut(int n, int n2, double d, double d2, Dockable dockable) {
        DockableDisplayer dockableDisplayer = this.getDisplayer();
        if (dockableDisplayer == null) {
            return null;
        }
        Rectangle rectangle = this.getBounds();
        PutInfo putInfo = null;
        if (dockableDisplayer.getTitle() != null) {
            int n3;
            if (dockableDisplayer.getTitleLocation() == DockableDisplayer.Location.TOP) {
                n3 = dockableDisplayer.getTitle().getComponent().getHeight();
                rectangle.y += n3;
                rectangle.height -= n3;
                if (n2 <= rectangle.y) {
                    putInfo = this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.TITLE, dockable));
                }
            } else if (dockableDisplayer.getTitleLocation() == DockableDisplayer.Location.BOTTOM) {
                n3 = dockableDisplayer.getTitle().getComponent().getHeight();
                rectangle.height -= n3;
                if (n2 >= rectangle.y + rectangle.height) {
                    putInfo = this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.TITLE, dockable));
                }
            } else if (dockableDisplayer.getTitleLocation() == DockableDisplayer.Location.LEFT) {
                n3 = dockableDisplayer.getTitle().getComponent().getWidth();
                rectangle.x += n3;
                rectangle.width -= n3;
                if (n <= rectangle.x) {
                    putInfo = this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.TITLE, dockable));
                }
            } else if (dockableDisplayer.getTitleLocation() == DockableDisplayer.Location.RIGHT) {
                n3 = dockableDisplayer.getTitle().getComponent().getWidth();
                rectangle.width -= n3;
                if (n >= rectangle.x + rectangle.width) {
                    putInfo = this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.TITLE, dockable));
                }
            }
        }
        if (putInfo != null) {
            return putInfo;
        }
        float f = this.getAccess().getOwner().getSideSnapSize();
        if ((float)n > (float)rectangle.x + f * (float)rectangle.width && (float)n < (float)(rectangle.x + rectangle.width) - f * (float)rectangle.width && (float)n2 > (float)rectangle.y + f * (float)rectangle.height && (float)n2 < (float)(rectangle.y + rectangle.height) - f * (float)rectangle.height) {
            putInfo = this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.CENTER, dockable));
        }
        if (putInfo != null) {
            return putInfo;
        }
        putInfo = Leaf.above(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, n, n2) ? (Leaf.above(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y, n, n2) ? this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.TOP, dockable)) : this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.RIGHT, dockable))) : (Leaf.above(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y, n, n2) ? this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.LEFT, dockable)) : this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.BOTTOM, dockable)));
        if (putInfo != null) {
            return putInfo;
        }
        return this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.CENTER, dockable));
    }

    @Override
    public boolean isInOverrideZone(int n, int n2, double d, double d2) {
        float f = this.getAccess().getOwner().getSideSnapSize();
        Rectangle rectangle = this.getBounds();
        return !((float)n > (float)rectangle.x + f * (float)rectangle.width) || !((float)n < (float)(rectangle.x + rectangle.width) - f * (float)rectangle.width) || !((float)n2 > (float)rectangle.y + f * (float)rectangle.height) || !((float)n2 < (float)(rectangle.y + rectangle.height) - f * (float)rectangle.height);
    }

    @Override
    public void evolve(SplitDockTree.Key key, boolean bl, Map<Leaf, Dockable> map) {
        this.setPlaceholders(key.getTree().getPlaceholders(key));
        this.setPlaceholderMap(key.getTree().getPlaceholderMap(key));
    }

    @Override
    public boolean insert(SplitDockPlaceholderProperty splitDockPlaceholderProperty, Dockable dockable) {
        Path path = splitDockPlaceholderProperty.getPlaceholder();
        if (this.hasPlaceholder(path)) {
            boolean bl;
            DockStation dockStation = this.getDockable().asDockStation();
            DockableProperty dockableProperty = splitDockPlaceholderProperty.getSuccessor();
            if (dockStation != null && dockableProperty != null && dockable.accept(dockStation) && dockStation.accept(dockable)) {
                boolean bl2;
                MultiDockAcceptance multiDockAcceptance;
                DockController dockController = this.getAccess().getOwner().getController();
                MultiDockAcceptance multiDockAcceptance2 = multiDockAcceptance = dockController == null ? null : dockController.getAcceptance();
                if ((multiDockAcceptance == null || multiDockAcceptance.accept(dockStation, dockable)) && (bl2 = dockStation.drop(dockable, dockableProperty))) {
                    this.getAccess().getPlaceholderSet().set(null, path, this);
                    return true;
                }
            }
            if (bl = this.getAccess().drop(dockable, splitDockPlaceholderProperty.toSplitLocation(this), this)) {
                this.removePlaceholder(path);
            }
            return bl;
        }
        return false;
    }

    @Override
    public boolean insert(SplitDockPathProperty splitDockPathProperty, int n, Dockable dockable) {
        if (n < splitDockPathProperty.size()) {
            Node node;
            Leaf leaf;
            SplitDockPathProperty.Node node2 = splitDockPathProperty.getNode(n);
            SplitDockStation.Orientation orientation = node2.getLocation() == SplitDockPathProperty.Location.LEFT || node2.getLocation() == SplitDockPathProperty.Location.RIGHT ? SplitDockStation.Orientation.HORIZONTAL : SplitDockStation.Orientation.VERTICAL;
            boolean bl = node2.getLocation() == SplitDockPathProperty.Location.RIGHT || node2.getLocation() == SplitDockPathProperty.Location.BOTTOM;
            SplitDockPathProperty.Node node3 = splitDockPathProperty.getLastNode();
            long l = -1L;
            if (node3 != null) {
                l = node3.getId();
            }
            if ((leaf = this.create(dockable, splitDockPathProperty.getLeafId())) == null) {
                return false;
            }
            SplitNode splitNode = this.getParent();
            int n2 = splitNode.getChildLocation(this);
            if (bl) {
                node = new Node(this.getAccess(), this, leaf, orientation, l);
                node.setDivider(1.0 - node2.getSize());
            } else {
                node = new Node(this.getAccess(), leaf, this, orientation, l);
                node.setDivider(node2.getSize());
            }
            splitNode.setChild(node, n2);
            leaf.setDockable(dockable, true);
            return true;
        }
        DockStation dockStation = this.getDockable().asDockStation();
        DockableProperty dockableProperty = splitDockPathProperty.getSuccessor();
        if (dockStation != null && dockableProperty != null && dockable.accept(dockStation) && dockStation.accept(dockable)) {
            boolean bl;
            MultiDockAcceptance multiDockAcceptance;
            DockController dockController = this.getAccess().getOwner().getController();
            MultiDockAcceptance multiDockAcceptance2 = multiDockAcceptance = dockController == null ? null : dockController.getAcceptance();
            if ((multiDockAcceptance == null || multiDockAcceptance.accept(dockStation, dockable)) && (bl = dockStation.drop(dockable, dockableProperty))) {
                return true;
            }
        }
        return this.getAccess().drop(dockable, splitDockPathProperty.toLocation(this), this);
    }

    @Override
    public <N> N submit(SplitTreeFactory<N> splitTreeFactory) {
        DockStation dockStation;
        Dockable dockable;
        PlaceholderMap placeholderMap = this.getPlaceholderMap();
        if (placeholderMap == null && (dockable = this.getDockable()) != null && (dockStation = dockable.asDockStation()) != null) {
            placeholderMap = dockStation.getPlaceholders();
        }
        return splitTreeFactory.leaf(this.getDockable(), this.getId(), this.getPlaceholders(), placeholderMap);
    }

    @Override
    public Leaf getLeaf(Dockable dockable) {
        Dockable dockable2 = this.getDockable();
        if (dockable2 != null && dockable == this.getDockable()) {
            return this;
        }
        return null;
    }

    @Override
    public Node getDividerNode(int n, int n2) {
        return null;
    }

    @Override
    public void visit(SplitNodeVisitor splitNodeVisitor) {
        splitNodeVisitor.handleLeaf(this);
    }

    @Override
    public void toString(int n, StringBuilder stringBuilder) {
        Dockable dockable = this.getDockable();
        stringBuilder.append("Leaf[ ");
        if (dockable != null) {
            stringBuilder.append(dockable.getTitleText());
            stringBuilder.append(", ");
        }
        stringBuilder.append("placeholders={");
        Path[] pathArray = this.getPlaceholders();
        if (pathArray != null) {
            for (int i = 0; i < pathArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(pathArray[i].toString());
            }
        }
        stringBuilder.append("}, ");
        stringBuilder.append("id=");
        stringBuilder.append(this.getId());
        stringBuilder.append(" ]");
    }
}

