/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.SplitDockAccess;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.split.SplitNodeVisitor;
import bibliothek.gui.dock.station.split.SplitTreeFactory;
import bibliothek.gui.dock.station.split.VisibleSplitNode;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Root
extends VisibleSplitNode {
    private SplitNode child;
    private boolean treeChanged = true;

    public Root(SplitDockAccess splitDockAccess) {
        super(splitDockAccess, -1L);
    }

    public Root(SplitDockAccess splitDockAccess, long l) {
        super(splitDockAccess, l);
    }

    @Override
    protected void treeChanged() {
        this.treeChanged = true;
    }

    public boolean hasTreeChanged() {
        return this.treeChanged;
    }

    public void setChild(SplitNode splitNode) {
        if (this.child != null) {
            this.child.setParent(null);
        }
        this.child = splitNode;
        if (splitNode != null) {
            splitNode.delete(false);
            splitNode.setParent(this);
        }
        this.treeChanged();
        this.getAccess().getOwner().revalidate();
        this.getAccess().getOwner().repaint();
    }

    public SplitNode getChild() {
        return this.child;
    }

    @Override
    public int getChildLocation(SplitNode splitNode) {
        if (splitNode == this.child) {
            return 0;
        }
        return -1;
    }

    @Override
    public void setChild(SplitNode splitNode, int n) {
        if (n != 0) {
            throw new IllegalArgumentException("Location invalid: " + n);
        }
        this.setChild(splitNode);
    }

    @Override
    public Root getRoot() {
        return this;
    }

    @Override
    public boolean isOfUse() {
        return true;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension;
        Dimension dimension2 = dimension = this.child == null ? null : this.child.getMinimumSize();
        if (dimension == null) {
            return new Dimension(0, 0);
        }
        return dimension;
    }

    public double getWidthFactor() {
        Insets insets = this.getAccess().getOwner().getInsets();
        return this.getAccess().getOwner().getWidth() - insets.left - insets.right;
    }

    public double getHeightFactor() {
        Insets insets = this.getAccess().getOwner().getInsets();
        return this.getAccess().getOwner().getHeight() - insets.top - insets.bottom;
    }

    public PutInfo getPut(int n, int n2, Dockable dockable) {
        double d = this.getWidthFactor();
        double d2 = this.getHeightFactor();
        return this.getPut(n, n2, d, d2, dockable);
    }

    public boolean isInOverrideZone(int n, int n2) {
        double d = this.getWidthFactor();
        double d2 = this.getHeightFactor();
        return this.isInOverrideZone(n, n2, d, d2);
    }

    @Override
    public void evolve(SplitDockTree.Key key, boolean bl, Map<Leaf, Dockable> map) {
        this.setChild(this.create(key, bl, map));
    }

    @Override
    public boolean insert(SplitDockPlaceholderProperty splitDockPlaceholderProperty, Dockable dockable) {
        boolean bl;
        boolean bl2 = bl = this.child != null && this.child.insert(splitDockPlaceholderProperty, dockable);
        if (!bl) {
            return this.getAccess().drop(dockable, splitDockPlaceholderProperty.toSplitLocation(this), this);
        }
        return true;
    }

    @Override
    public boolean insert(SplitDockPathProperty splitDockPathProperty, int n, Dockable dockable) {
        if (this.child == null) {
            Leaf leaf;
            int n2 = splitDockPathProperty.size();
            long l = -1L;
            if (n2 > 0) {
                l = splitDockPathProperty.getNode(n2 - 1).getId();
            }
            if ((leaf = this.create(dockable, l)) == null) {
                return false;
            }
            this.setChild(leaf);
            leaf.setDockable(dockable, true);
            return true;
        }
        return this.child.insert(splitDockPathProperty, n, dockable);
    }

    @Override
    public <N> N submit(SplitTreeFactory<N> splitTreeFactory) {
        if (this.child == null) {
            return splitTreeFactory.root(null, this.getId());
        }
        return splitTreeFactory.root(this.child.submit(splitTreeFactory), this.getId());
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public SplitNode getVisible() {
        return this;
    }

    @Override
    public void updateBounds(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        super.updateBounds(d, d2, d3, d4, d5, d6, bl);
        if (this.child != null) {
            this.child.updateBounds(d, d2, d3, d4, d5, d6, bl);
        }
        this.treeChanged = false;
    }

    @Override
    public PutInfo getPut(int n, int n2, double d, double d2, Dockable dockable) {
        if (!this.getBounds().contains(n, n2)) {
            return null;
        }
        if (this.child != null) {
            return this.child.getPut(n, n2, d, d2, dockable);
        }
        return null;
    }

    @Override
    public boolean isInOverrideZone(int n, int n2, double d, double d2) {
        if (!this.getBounds().contains(n, n2)) {
            return false;
        }
        if (this.child != null) {
            return this.child.isInOverrideZone(n, n2, d, d2);
        }
        return false;
    }

    @Override
    public Leaf getLeaf(Dockable dockable) {
        return this.child == null ? null : this.child.getLeaf(dockable);
    }

    @Override
    public Node getDividerNode(int n, int n2) {
        if (this.child == null) {
            return null;
        }
        return this.child.getDividerNode(n, n2);
    }

    @Override
    public void visit(SplitNodeVisitor splitNodeVisitor) {
        splitNodeVisitor.handleRoot(this);
        if (this.child != null) {
            this.child.visit(splitNodeVisitor);
        }
    }

    @Override
    public void toString(int n, StringBuilder stringBuilder) {
        stringBuilder.append("Root [id=");
        stringBuilder.append(this.getId());
        stringBuilder.append("]\n");
        for (int i = 0; i < n + 1; ++i) {
            stringBuilder.append('\t');
        }
        if (this.child != null) {
            this.child.toString(n + 1, stringBuilder);
        } else {
            stringBuilder.append("<null>");
        }
    }
}

