/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CGrid;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.intern.AbstractDockableCStation;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.station.CommonStation;
import bibliothek.gui.dock.common.intern.station.CommonStationDelegate;
import bibliothek.gui.dock.common.intern.station.SplitResizeRequestHandler;
import bibliothek.gui.dock.common.location.CGridAreaLocation;
import bibliothek.gui.dock.common.mode.CMaximizedMode;
import bibliothek.gui.dock.common.mode.station.CSplitDockStationHandle;
import bibliothek.gui.dock.common.perspective.CGridPerspective;
import bibliothek.gui.dock.common.perspective.CStationPerspective;
import bibliothek.gui.dock.title.DockTitleVersion;
import javax.swing.Icon;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CGridArea
extends AbstractDockableCStation<SplitDockStation>
implements SingleCDockable {
    private String uniqueId;
    private SplitDockStation station;
    private SplitResizeRequestHandler resizeRequestHandler;
    private CSplitDockStationHandle modeManagerHandle;
    private boolean maximizing = false;

    public CGridArea(CControl control, String uniqueId) {
        this.init(control, uniqueId);
    }

    protected CGridArea() {
    }

    protected void init(CControl control, String uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("id must not be null");
        }
        this.uniqueId = uniqueId;
        CommonStation<SplitDockStation> station = control.getFactory().createSplitDockStation(new Delegate());
        this.station = station.asDockStation();
        this.init(station);
        this.setTitleShown(false);
        this.station.setExpandOnDoubleclick(false);
        this.resizeRequestHandler = new SplitResizeRequestHandler(this.station);
        this.setMaximizingArea(true);
        this.modeManagerHandle = new CSplitDockStationHandle(this, control.getLocationManager());
    }

    @Override
    protected CommonDockable createCommonDockable() {
        throw new IllegalStateException("the common-dockable gets already initialized by the constructor");
    }

    public void deploy(CGrid grid) {
        this.station.dropTree(grid.toTree());
    }

    @Override
    public SplitDockStation getStation() {
        return this.station;
    }

    @Override
    public CDockable asDockable() {
        return this;
    }

    @Override
    public CStationPerspective createPerspective() {
        return new CGridPerspective(this.getUniqueId(), this.isWorkingArea());
    }

    public JComponent getComponent() {
        return this.station;
    }

    @Override
    public CLocation getStationLocation() {
        return new CGridAreaLocation(this);
    }

    public void setTitleText(String text) {
        this.station.setTitleText(text);
    }

    public String getTitleText() {
        return this.station.getTitleText();
    }

    public void setTitleIcon(Icon icon) {
        this.station.setTitleIcon(icon);
    }

    public Icon getTitleIcon() {
        return this.station.getTitleIcon();
    }

    public void setMaximizingArea(boolean maximize) {
        if (maximize != this.maximizing) {
            this.maximizing = maximize;
            CControlAccess access = this.getControl();
            if (access != null) {
                CMaximizedMode mode = access.getLocationManager().getMaximizedMode();
                if (this.maximizing) {
                    mode.add(this.modeManagerHandle.asMaximziedModeArea());
                } else {
                    mode.remove(this.modeManagerHandle.asMaximziedModeArea().getUniqueId());
                }
            }
        }
    }

    public boolean isMaximizingArea() {
        return this.maximizing;
    }

    @Override
    protected void install(CControlAccess access) {
        access.getLocationManager().getNormalMode().add(this.modeManagerHandle.asNormalModeArea());
        access.getOwner().addResizeRequestListener(this.resizeRequestHandler);
        if (this.isMaximizingArea()) {
            CMaximizedMode mode = access.getLocationManager().getMaximizedMode();
            mode.add(this.modeManagerHandle.asMaximziedModeArea());
        }
    }

    @Override
    protected void uninstall(CControlAccess access) {
        access.getLocationManager().getNormalMode().remove(this.modeManagerHandle.asNormalModeArea().getUniqueId());
        access.getOwner().removeResizeRequestListener(this.resizeRequestHandler);
        if (this.isMaximizingArea()) {
            CMaximizedMode mode = access.getLocationManager().getMaximizedMode();
            mode.remove(this.modeManagerHandle.asMaximziedModeArea().getUniqueId());
        }
    }

    @Override
    public boolean isCloseable() {
        return false;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public boolean isExternalizable() {
        return false;
    }

    @Override
    public boolean isMaximizable() {
        return false;
    }

    @Override
    public boolean isMinimizable() {
        return false;
    }

    @Override
    public boolean isStackable() {
        return false;
    }

    @Override
    public boolean isWorkingArea() {
        return false;
    }

    protected boolean suppressTitle(DockTitleVersion version) {
        if (!this.isTitleShown()) {
            if (version.getID().equals("split")) {
                return true;
            }
            if (version.getID().equals("flap window")) {
                return true;
            }
            if (version.getID().equals("screen dock")) {
                return true;
            }
            if (version.getID().equals("stack")) {
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Delegate
    implements CommonStationDelegate {
        private Delegate() {
        }

        @Override
        public CDockable getDockable() {
            return CGridArea.this;
        }

        @Override
        public DockActionSource[] getSources() {
            return new DockActionSource[]{CGridArea.this.getClose()};
        }

        public CStation<SplitDockStation> getStation() {
            return CGridArea.this;
        }

        @Override
        public boolean isTitleDisplayed(DockTitleVersion title) {
            return !CGridArea.this.suppressTitle(title);
        }
    }
}

