/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.Placeholder;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SplitDockAccess;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.split.SplitNodeVisitor;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.RootPlaceholderStrategy;
import bibliothek.util.Path;
import java.util.ArrayList;
import java.util.HashSet;

public class SplitPlaceholderSet {
    private SplitDockAccess access;

    public SplitPlaceholderSet(SplitDockAccess access) {
        this.access = access;
    }

    public void set(SplitNode node, Dockable dockable, SplitNode ... protectedNodes) {
        Path placeholder;
        RootPlaceholderStrategy strategy = this.access.getOwner().getPlaceholderStrategy();
        if (strategy != null && (placeholder = strategy.getPlaceholderFor(dockable)) != null) {
            this.set(node, placeholder, protectedNodes);
        }
    }

    public void set(final SplitNode node, final Path placeholder, SplitNode ... protectedNodes) {
        final ArrayList nodesToDelete = new ArrayList();
        Root root = this.access.getOwner().getRoot();
        root.visit(new SplitNodeVisitor(){

            public void handleRoot(Root root) {
                this.handle(root);
            }

            public void handlePlaceholder(Placeholder placeholder2) {
                this.handle(placeholder2);
            }

            public void handleNode(Node node2) {
                this.handle(node2);
            }

            public void handleLeaf(Leaf leaf) {
                this.handle(leaf);
            }

            private void handle(SplitNode check) {
                if (check != node) {
                    check.removePlaceholder(placeholder);
                    PlaceholderMap map = check.getPlaceholderMap();
                    if (map != null) {
                        map.removeAll(placeholder, true);
                    }
                    if (!check.isOfUse()) {
                        nodesToDelete.add(check);
                    }
                }
            }
        });
        if (node != null) {
            node.addPlaceholder(placeholder);
        }
        if (this.access.isTreeAutoCleanupEnabled()) {
            for (SplitNode protectedNode : protectedNodes) {
                nodesToDelete.remove(protectedNode);
            }
            for (SplitNode delete : nodesToDelete) {
                delete.delete(true);
            }
        }
    }

    public void removeDoublePlaceholders(final SplitNode node, PlaceholderMap map) {
        final HashSet<Path> placeholdersToRemove = new HashSet<Path>();
        final RootPlaceholderStrategy strategy = this.access.getOwner().getPlaceholderStrategy();
        Root root = this.access.getOwner().getRoot();
        root.visit(new SplitNodeVisitor(){

            public void handleRoot(Root root) {
                this.handle(root);
            }

            public void handlePlaceholder(Placeholder placeholder) {
                this.handle(placeholder);
            }

            public void handleNode(Node node2) {
                this.handle(node2);
            }

            public void handleLeaf(Leaf leaf) {
                if (leaf != node) {
                    this.handle(leaf);
                    this.handle(leaf.getDockable());
                }
            }

            private void handle(SplitNode check) {
                if (check != node) {
                    for (Path placeholder : node.getPlaceholders()) {
                        placeholdersToRemove.add(placeholder);
                    }
                }
            }

            private void handle(Dockable dockable) {
                if (strategy != null && dockable != null) {
                    DockStation station;
                    Path placeholder = strategy.getPlaceholderFor(dockable);
                    if (placeholder != null) {
                        placeholdersToRemove.add(placeholder);
                    }
                    if ((station = dockable.asDockStation()) != null) {
                        int n = station.getDockableCount();
                        for (int i = 0; i < n; ++i) {
                            this.handle(station.getDockable(i));
                        }
                    }
                }
            }
        });
        map.removeAll(placeholdersToRemove, true);
    }
}

