/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.station.stack.CombinedHandler;
import bibliothek.gui.dock.station.stack.CombinedInfoComponent;
import bibliothek.gui.dock.station.stack.CombinedMenu;
import bibliothek.gui.dock.station.stack.CombinedStackDockContentPane;
import bibliothek.gui.dock.station.stack.CombinedTab;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.tab.AbstractTabPane;
import bibliothek.gui.dock.station.stack.tab.AbstractTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.LonelyTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.TabPaneBackgroundComponent;
import bibliothek.gui.dock.station.stack.tab.TabPaneListener;
import bibliothek.gui.dock.themes.border.BorderForwarder;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundPanel;
import bibliothek.gui.dock.util.SimpleDockElementRepresentative;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CombinedStackDockComponent<T extends CombinedTab, M extends CombinedMenu, I extends CombinedInfoComponent>
extends AbstractTabPane<T, M, I>
implements StackDockComponent {
    private CombinedStackDockContentPane panel;
    private Map<Dockable, Meta> components = new HashMap<Dockable, Meta>();
    private BackgroundAlgorithm background;
    private BackgroundPanel componentPanel = new BackgroundPanel(null, true, false){

        public void doLayout() {
            int w = this.getWidth();
            int h = this.getHeight();
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                this.getComponent(i).setBounds(0, 0, w, h);
            }
        }

        public Dimension getPreferredSize() {
            Dimension base = new Dimension(0, 0);
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Dimension next = this.getComponent(i).getPreferredSize();
                base.width = Math.max(base.width, next.width);
                base.height = Math.max(base.height, next.height);
            }
            return base;
        }

        public Dimension getMinimumSize() {
            Dimension base = new Dimension(0, 0);
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Dimension next = this.getComponent(i).getMinimumSize();
                base.width = Math.max(base.width, next.width);
                base.height = Math.max(base.height, next.height);
            }
            return base;
        }
    };
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private CombinedHandler<CombinedTab> tabHandler = new CombinedHandler<CombinedTab>(){

        @Override
        public void setVisible(CombinedTab tab, boolean visible) {
            DockController controller = CombinedStackDockComponent.this.getController();
            if (visible) {
                CombinedStackDockComponent.this.panel.add(tab.getComponent());
                if (controller != null) {
                    controller.addRepresentative(tab);
                }
            } else {
                CombinedStackDockComponent.this.panel.remove(tab.getComponent());
                if (controller != null) {
                    controller.removeRepresentative(tab);
                }
            }
        }

        @Override
        public boolean isVisible(CombinedTab item) {
            return item.getComponent() != null && item.getComponent().getParent() == CombinedStackDockComponent.this.panel;
        }

        @Override
        public void setZOrder(CombinedTab item, int order) {
            CombinedStackDockComponent.this.setZOrder(item.getComponent(), order);
        }

        @Override
        public int getZOrder(CombinedTab item) {
            return CombinedStackDockComponent.this.getZOrder(item.getComponent());
        }
    };
    private CombinedHandler<CombinedMenu> menuHandler = new CombinedHandler<CombinedMenu>(){

        @Override
        public void setVisible(CombinedMenu menu, boolean visible) {
            if (visible) {
                CombinedStackDockComponent.this.panel.add(menu.getComponent());
            } else {
                CombinedStackDockComponent.this.panel.remove(menu.getComponent());
            }
        }

        @Override
        public boolean isVisible(CombinedMenu item) {
            return item.getComponent() != null && item.getComponent().getParent() == CombinedStackDockComponent.this.panel;
        }

        @Override
        public void setZOrder(CombinedMenu item, int order) {
            CombinedStackDockComponent.this.setZOrder(item.getComponent(), order);
        }

        @Override
        public int getZOrder(CombinedMenu item) {
            return CombinedStackDockComponent.this.getZOrder(item.getComponent());
        }
    };
    private CombinedHandler<AbstractTabPaneComponent> infoHandler = new CombinedHandler<AbstractTabPaneComponent>(){

        @Override
        public void setVisible(AbstractTabPaneComponent item, boolean visible) {
            if (visible) {
                CombinedStackDockComponent.this.panel.add(item.getComponent());
            } else {
                CombinedStackDockComponent.this.panel.remove(item.getComponent());
            }
        }

        @Override
        public boolean isVisible(AbstractTabPaneComponent item) {
            return item.getComponent() != null && item.getComponent().getParent() == CombinedStackDockComponent.this.panel;
        }

        @Override
        public void setZOrder(AbstractTabPaneComponent item, int order) {
            CombinedStackDockComponent.this.setZOrder(item.getComponent(), order);
        }

        @Override
        public int getZOrder(AbstractTabPaneComponent item) {
            return CombinedStackDockComponent.this.getZOrder(item.getComponent());
        }
    };

    public CombinedStackDockComponent() {
        this.background = this.createBackground(this);
        this.panel = this.createContentPane(this);
        this.panel.add(this.componentPanel);
        this.panel.setBackground(this.background);
        this.componentPanel.setBackground(this.background);
        this.addTabPaneListener(new TabPaneListener(){

            public void added(TabPane pane, Dockable dockable) {
            }

            public void removed(TabPane pane, Dockable dockable) {
            }

            public void selectionChanged(TabPane pane) {
                ChangeEvent event = new ChangeEvent(CombinedStackDockComponent.this);
                for (ChangeListener listener : CombinedStackDockComponent.this.listeners.toArray(new ChangeListener[CombinedStackDockComponent.this.listeners.size()])) {
                    listener.stateChanged(event);
                }
            }

            public void infoComponentChanged(TabPane pane, LonelyTabPaneComponent oldInfo, LonelyTabPaneComponent newInfo) {
            }
        });
    }

    protected CombinedStackDockContentPane createContentPane(CombinedStackDockComponent<T, M, I> self) {
        return new CombinedStackDockContentPane(self);
    }

    protected BackgroundAlgorithm createBackground(CombinedStackDockComponent<T, M, I> self) {
        return new Background();
    }

    @Override
    public void revalidate() {
        this.panel.revalidate();
        this.repaint();
    }

    public void repaint() {
        this.panel.repaint();
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setController(DockController controller) {
        DockController old = this.getController();
        if (old != controller) {
            List tabs = this.getTabsList();
            if (old != null) {
                for (CombinedTab tab : tabs) {
                    old.removeRepresentative(tab);
                }
            }
            if (controller != null) {
                for (CombinedTab tab : tabs) {
                    controller.addRepresentative(tab);
                }
            }
            for (Meta meta : this.components.values()) {
                meta.setController(controller);
            }
            this.background.setController(controller);
            super.setController(controller);
        }
    }

    public CombinedHandler<CombinedTab> getTabHandler() {
        return this.tabHandler;
    }

    public CombinedHandler<CombinedMenu> getMenuHandler() {
        return this.menuHandler;
    }

    public CombinedHandler<AbstractTabPaneComponent> getInfoHandler() {
        return this.infoHandler;
    }

    @Override
    public Rectangle getAvailableArea() {
        Insets insets = this.panel.getInsets();
        insets = insets == null ? new Insets(0, 0, 0, 0) : new Insets(insets.top, insets.left, insets.bottom, insets.right);
        return new Rectangle(insets.left, insets.top, Math.max(1, this.panel.getWidth() - insets.left - insets.right), Math.max(1, this.panel.getHeight() - insets.top - insets.bottom));
    }

    @Override
    public Rectangle getSelectedBounds() {
        return this.componentPanel.getBounds();
    }

    @Override
    public void setSelectedBounds(Rectangle bounds) {
        this.componentPanel.setBounds(bounds);
    }

    @Override
    public int getSelectedIndex() {
        return this.indexOf(this.getSelectedDockable());
    }

    @Override
    public void setSelectedIndex(int index) {
        if (index < 0 || index >= this.getDockableCount()) {
            this.setSelectedDockable(null);
        } else {
            this.setSelectedDockable(this.getDockable(index));
        }
    }

    @Override
    public void setSelectedDockable(Dockable dockable) {
        if (this.getSelectedDockable() != dockable) {
            super.setSelectedDockable(dockable);
            for (Meta entry : this.components.values()) {
                entry.component.setVisible(entry.dockable == dockable);
            }
        }
    }

    @Override
    public Rectangle getBoundsAt(int index) {
        CombinedTab tab = (CombinedTab)this.getTab(this.getDockable(index));
        if (tab == null) {
            return null;
        }
        return tab.getBounds();
    }

    @Override
    public int getTabCount() {
        return this.getDockableCount();
    }

    @Override
    public void addTab(String title, Icon icon, Component comp, Dockable dockable) {
        this.insertTab(title, icon, comp, dockable, this.getTabCount());
    }

    @Override
    public void insertTab(String title, Icon icon, Component comp, Dockable dockable, int index) {
        Component between = this.createLayerAt(comp, dockable);
        Meta meta = new Meta(dockable, between, title, icon, null);
        this.components.put(dockable, meta);
        this.componentPanel.add(between);
        this.insert(index, dockable);
        meta.forward();
        meta.component.setVisible(this.getSelectedDockable() == dockable);
    }

    @Override
    public Dockable getDockableAt(int index) {
        return this.getDockable(index);
    }

    @Override
    public void moveTab(int source, int destination) {
        if (source == destination) {
            return;
        }
        if (destination < 0 || destination >= this.getTabCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int selected = this.getSelectedIndex();
        this.move(source, destination);
        if (selected == source) {
            selected = destination;
        } else if (selected > source && selected <= destination) {
            ++selected;
        }
        this.setSelectedIndex(selected);
    }

    @Override
    public void remove(int index) {
        Dockable dockable = this.getDockable(index);
        super.remove(index);
        Meta meta = this.components.remove(dockable);
        meta.setController(null);
        this.componentPanel.remove(meta.component);
        meta.component.setVisible(true);
    }

    @Override
    public void removeAll() {
        super.removeAll();
        for (Meta meta : this.components.values()) {
            this.componentPanel.remove(meta.component);
            meta.setController(null);
            meta.component.setVisible(true);
        }
        this.components.clear();
    }

    @Override
    public T putOnTab(Dockable dockable) {
        CombinedTab tab = (CombinedTab)super.putOnTab(dockable);
        Meta meta = this.components.get(dockable);
        tab.setIcon(meta.icon);
        tab.setText(meta.text);
        tab.setTooltip(meta.tooltip);
        return (T)tab;
    }

    @Override
    protected void addToMenu(M menu, Dockable dockable) {
        int index = menu.getDockableCount();
        menu.insert(index, dockable);
        Meta meta = this.components.get(dockable);
        menu.setIcon(index, meta.icon);
        menu.setText(index, meta.text);
        menu.setTooltip(index, meta.tooltip);
    }

    @Override
    protected void removeFromMenu(M menu, Dockable dockable) {
        menu.remove(dockable);
    }

    protected Component createLayerAt(Component component, Dockable dockable) {
        return component;
    }

    public Component getLayerAt(int index) {
        return this.getContentAt(index).component;
    }

    protected Meta getContentAt(int index) {
        return this.components.get(this.getDockable(index));
    }

    @Override
    public void setTitleAt(int index, String newTitle) {
        Meta meta = this.components.get(this.getDockable(index));
        if (newTitle == null) {
            meta.text = "";
        } else {
            meta.text = newTitle;
        }
        meta.forward();
    }

    @Override
    public void setTooltipAt(int index, String newTooltip) {
        Meta meta = this.components.get(this.getDockable(index));
        meta.tooltip = newTooltip;
        meta.forward();
    }

    @Override
    public void setIconAt(int index, Icon newIcon) {
        Meta meta = this.components.get(this.getDockable(index));
        meta.icon = newIcon;
        meta.forward();
    }

    @Override
    public void setComponentAt(int index, Component component) {
        Meta meta = this.components.get(this.getDockable(index));
        this.componentPanel.remove(meta.component);
        meta.component = this.createLayerAt(component, meta.dockable);
        this.componentPanel.add(meta.component);
        meta.component.setVisible(this.getSelectedDockable() == meta.dockable);
        this.revalidate();
    }

    @Override
    public JComponent getComponent() {
        return this.panel;
    }

    protected void setZOrder(Component component, int order) {
        this.panel.setComponentZOrder(component, order);
    }

    protected int getZOrder(Component component) {
        return this.panel.getComponentZOrder(component);
    }

    @Override
    public DockElementRepresentative createDefaultRepresentation(DockElement target) {
        return new SimpleDockElementRepresentative(target, this.panel);
    }

    protected BorderForwarder createContentBorderModifier(Dockable dockable, JComponent component) {
        return null;
    }

    private class Background
    extends BackgroundAlgorithm
    implements TabPaneBackgroundComponent {
        public Background() {
            super(TabPaneBackgroundComponent.KIND, "dock.background.tabPane");
        }

        public TabPane getPane() {
            return CombinedStackDockComponent.this;
        }

        public Component getComponent() {
            return CombinedStackDockComponent.this.panel;
        }
    }

    protected class Meta {
        private Dockable dockable;
        private Component component;
        private String text;
        private Icon icon;
        private String tooltip;
        private BorderForwarder border;

        public Meta(Dockable dockable, Component component, String text, Icon icon, String tooltip) {
            this.dockable = dockable;
            this.component = component;
            this.text = text;
            this.icon = icon;
            this.tooltip = tooltip;
            if (component instanceof JComponent) {
                this.border = CombinedStackDockComponent.this.createContentBorderModifier(dockable, (JComponent)component);
            }
            this.setController(CombinedStackDockComponent.this.getController());
        }

        public void setController(DockController controller) {
            if (this.border != null) {
                this.border.setController(controller);
            }
        }

        public Dockable getDockable() {
            return this.dockable;
        }

        public Component getComponent() {
            return this.component;
        }

        public void setBorder(Border border) {
            if (this.border == null) {
                throw new IllegalStateException("there was no border-modifier created");
            }
            this.border.setBorder(border);
        }

        public void forward() {
            CombinedTab tab = (CombinedTab)CombinedStackDockComponent.this.getTab(this.dockable);
            if (tab != null) {
                tab.setIcon(this.icon);
                tab.setText(this.text);
                tab.setTooltip(this.tooltip);
            } else {
                CombinedMenu menu = (CombinedMenu)CombinedStackDockComponent.this.getMenu(this.dockable);
                if (menu != null) {
                    Dockable[] dockables = menu.getDockables();
                    for (int i = 0; i < dockables.length; ++i) {
                        if (dockables[i] != this.dockable) continue;
                        menu.setIcon(i, this.icon);
                        menu.setText(i, this.text);
                        menu.setTooltip(i, this.tooltip);
                        break;
                    }
                }
            }
        }
    }
}

