/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.control.DockRegister;
import bibliothek.gui.dock.event.UIListener;
import bibliothek.gui.dock.station.Combiner;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.themes.DockThemeExtension;
import bibliothek.gui.dock.themes.border.BorderModifier;
import bibliothek.gui.dock.util.BackgroundPaint;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.TypedPropertyUIScheme;
import bibliothek.gui.dock.util.TypedUIProperties;
import bibliothek.gui.dock.util.UIBridge;
import bibliothek.gui.dock.util.UIValue;
import bibliothek.gui.dock.util.extension.ExtensionName;
import bibliothek.util.Path;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThemeManager
extends TypedUIProperties {
    public static final TypedUIProperties.Type<StationPaint> STATION_PAINT_TYPE = new TypedUIProperties.Type("StationPaint");
    public static final String STATION_PAINT = "dock.paint";
    public static final TypedUIProperties.Type<Combiner> COMBINER_TYPE = new TypedUIProperties.Type("Combiner");
    public static final String COMBINER = "dock.combiner";
    public static final TypedUIProperties.Type<DisplayerFactory> DISPLAYER_FACTORY_TYPE = new TypedUIProperties.Type("DisplayerFactory");
    public static final String DISPLAYER_FACTORY = "dock.displayer";
    public static final TypedUIProperties.Type<BackgroundPaint> BACKGROUND_PAINT_TYPE = new TypedUIProperties.Type("BackgroundPaint");
    public static final String BACKGROUND_PAINT = "dock.background";
    public static final TypedUIProperties.Type<BorderModifier> BORDER_MODIFIER_TYPE = new TypedUIProperties.Type("BorderModifier");
    public static final String BORDER_MODIFIER = "dock.border";
    private DockController controller;
    private DockTheme theme;
    private List<UIListener> uiListeners = new ArrayList<UIListener>();
    private PropertyChangeListener lookAndFeelObserver = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if ("lookAndFeel".equals(evt.getPropertyName())) {
                ThemeManager.this.updateUI();
            }
        }
    };
    private TypedPropertyUIScheme transfers;

    public ThemeManager(DockController controller) {
        super(controller);
        if (controller == null) {
            throw new IllegalArgumentException("controller must not be null");
        }
        this.controller = controller;
        UIManager.addPropertyChangeListener(this.lookAndFeelObserver);
        this.transfers = new TypedPropertyUIScheme(controller.getProperties());
        this.setScheme(Priority.THEME, this.transfers);
    }

    public void init() {
        this.registerTypes();
        this.link();
    }

    private void registerTypes() {
        this.registerType(STATION_PAINT_TYPE);
        this.registerType(COMBINER_TYPE);
        this.registerType(DISPLAYER_FACTORY_TYPE);
        this.registerType(BACKGROUND_PAINT_TYPE);
        this.registerType(BORDER_MODIFIER_TYPE);
    }

    private void link() {
        this.link(DockTheme.STATION_PAINT, STATION_PAINT_TYPE, STATION_PAINT);
        this.link(DockTheme.COMBINER, COMBINER_TYPE, COMBINER);
        this.link(DockTheme.DISPLAYER_FACTORY, DISPLAYER_FACTORY_TYPE, DISPLAYER_FACTORY);
        this.link(DockTheme.BACKGROUND_PAINT, BACKGROUND_PAINT_TYPE, BACKGROUND_PAINT);
        this.link(DockTheme.BORDER_MODIFIER, BORDER_MODIFIER_TYPE, BORDER_MODIFIER);
    }

    public void kill() {
        this.theme.uninstall(this.controller);
        UIManager.removePropertyChangeListener(this.lookAndFeelObserver);
    }

    public <V, A extends V> void link(PropertyKey<A> source, TypedUIProperties.Type<V> type, String id) {
        this.transfers.link(source, type, id);
    }

    public <V> void unlink(TypedUIProperties.Type<V> type, String id) {
        this.transfers.unlink(type, id);
    }

    public void addUIListener(UIListener listener) {
        this.uiListeners.add(listener);
    }

    public void removeUIListener(UIListener listener) {
        this.uiListeners.remove(listener);
    }

    protected UIListener[] uiListeners() {
        return this.uiListeners.toArray(new UIListener[this.uiListeners.size()]);
    }

    public void updateUI() {
        for (UIListener listener : this.uiListeners()) {
            listener.updateUI(this.controller);
        }
    }

    public DockTheme getTheme() {
        return this.theme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTheme(DockTheme theme) {
        if (theme == null) {
            throw new IllegalArgumentException("Theme must not be null");
        }
        if (this.theme != theme) {
            for (UIListener listener : this.uiListeners()) {
                listener.themeWillChange(this.controller, this.theme, theme);
            }
            DockRegister register = this.controller.getRegister();
            DockTheme oldTheme = this.theme;
            Dockable focused = null;
            try {
                register.setStalled(true);
                focused = this.controller.getFocusedDockable();
                if (this.theme != null) {
                    this.theme.uninstall(this.controller);
                }
                this.theme = theme;
                ExtensionName<DockThemeExtension> name = new ExtensionName<DockThemeExtension>(DockThemeExtension.DOCK_THEME_EXTENSION, DockThemeExtension.class, "theme", theme);
                List<DockThemeExtension> extensions = this.controller.getExtensions().load(name);
                theme.install(this.controller, extensions.toArray(new DockThemeExtension[extensions.size()]));
                this.controller.getDockTitleManager().registerTheme("theme", theme.getTitleFactory(this.controller));
                for (DockStation station : register.listDockStations()) {
                    if (station.getController() != this.controller) continue;
                    station.updateTheme();
                }
            }
            finally {
                register.setStalled(false);
            }
            this.controller.setFocusedDockable(focused, null, true);
            for (UIListener listener : this.uiListeners()) {
                listener.themeChanged(this.controller, oldTheme, theme);
            }
        }
    }

    public void setStationPaint(String id, StationPaint value) {
        this.put(Priority.CLIENT, id, STATION_PAINT_TYPE, value);
    }

    public void setStationPaintBridge(Path kind, UIBridge<StationPaint, UIValue<StationPaint>> bridge) {
        if (bridge == null) {
            this.unpublish(Priority.CLIENT, kind, STATION_PAINT_TYPE);
        } else {
            this.publish(Priority.CLIENT, kind, STATION_PAINT_TYPE, bridge);
        }
    }

    public void setCombiner(String id, Combiner value) {
        this.put(Priority.CLIENT, id, COMBINER_TYPE, value);
    }

    public void setCombinerBridge(Path kind, UIBridge<Combiner, UIValue<Combiner>> bridge) {
        if (bridge == null) {
            this.unpublish(Priority.CLIENT, kind, COMBINER_TYPE);
        } else {
            this.publish(Priority.CLIENT, kind, COMBINER_TYPE, bridge);
        }
    }

    public void setDisplayerFactory(String id, DisplayerFactory value) {
        this.put(Priority.CLIENT, id, DISPLAYER_FACTORY_TYPE, value);
    }

    public void setDisplayerFactoryBridge(Path kind, UIBridge<DisplayerFactory, UIValue<DisplayerFactory>> bridge) {
        if (bridge == null) {
            this.unpublish(Priority.CLIENT, kind, DISPLAYER_FACTORY_TYPE);
        } else {
            this.publish(Priority.CLIENT, kind, DISPLAYER_FACTORY_TYPE, bridge);
        }
    }

    public void setBackgroundPaint(String id, BackgroundPaint value) {
        this.put(Priority.CLIENT, id, BACKGROUND_PAINT_TYPE, value);
    }

    public void setBackgroundPaintBridge(Path kind, UIBridge<BackgroundPaint, UIValue<BackgroundPaint>> bridge) {
        if (bridge == null) {
            this.unpublish(Priority.CLIENT, kind, BACKGROUND_PAINT_TYPE);
        } else {
            this.publish(Priority.CLIENT, kind, BACKGROUND_PAINT_TYPE, bridge);
        }
    }

    public void setBorderModifier(String id, BorderModifier modifier) {
        this.put(Priority.CLIENT, id, BORDER_MODIFIER_TYPE, modifier);
    }

    public void setBorderModifierBridge(Path kind, UIBridge<BorderModifier, UIValue<BorderModifier>> bridge) {
        if (bridge == null) {
            this.unpublish(Priority.CLIENT, kind, BORDER_MODIFIER_TYPE);
        } else {
            this.publish(Priority.CLIENT, kind, BORDER_MODIFIER_TYPE, bridge);
        }
    }
}

