% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-files.R
\name{spell_check_files}
\alias{spell_check_files}
\alias{spell_check_text}
\title{Spell Check}
\usage{
spell_check_files(path, ignore = character(), lang = "en_US")

spell_check_text(text, ignore = character(), lang = "en_US")
}
\arguments{
\item{path}{path to file or to spell check}

\item{ignore}{character vector with words which will be added to the \link[hunspell:dictionary]{hunspell::dictionary}}

\item{lang}{set \code{Language} field in \code{DESCRIPTION} e.g. \code{"en-US"} or \code{"en-GB"}.}

\item{text}{character vector with plain text}
}
\description{
Perform a spell check on document files or plain text.
}
\examples{
# Example files
files <- list.files(system.file("examples", package = "knitr"),
  pattern = "\\\\.(Rnw|Rmd|html)$", full.names = TRUE)
spell_check_files(files)
}
\seealso{
Other spelling: \code{\link{spell_check_package}},
  \code{\link{wordlist}}
}
