% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MI.decomp.R
\name{MI.decomp}
\alias{MI.decomp}
\title{Decomposition of the Moran Coefficient}
\usage{
MI.decomp(x, W, nsim = 100)
}
\arguments{
\item{x}{a vector or matrix}

\item{W}{spatial connectivity matrix}

\item{nsim}{number of iterations to simulate the null distribution}
}
\value{
Returns a \code{data.frame} that contains the following information
for each variable:
\describe{
\item{\code{I+}}{observed value of Moran's I (positive part)}
\item{\code{VarI+}}{variance of Moran's I (positive part)}
\item{\code{pI+}}{simulated \emph{p}-value of Moran's I (positive part)}
\item{\code{I-}}{observed value of Moran's I (negative part)}
\item{\code{VarI-}}{variance of Moran's I (negative part)}
\item{\code{pI-}}{simulated \emph{p}-value of Moran's I (negative part)}
\item{\code{pItwo.sided}}{simulated \emph{p}-value of the two-sided test}
}
}
\description{
A decomposition of the Moran coefficient in order to separately
test for the simultaneous presence of positive and negative autocorrelation
in a variable.
}
\details{
If \code{x} is a matrix, this function computes the Moran
test for spatial autocorrelation for each column.

The \emph{p}-values calculated for \code{I+} and \code{I-} assume
a directed alternative hypothesis. Statistical significance is assessed
using a permutation procedure to generate a simulated null distribution.
}
\examples{
data(fakedata)
X <- cbind(fakedataset$x1,fakedataset$x2
,fakedataset$x3,fakedataset$negative)

(MI.dec <- MI.decomp(x=X,W=W,nsim=100))

# the sum of I+ and I- equals the observed Moran coefficient:
I <- MI.vec(x=X,W=W)[,"I"]
cbind(MI.dec[,"I+"] + MI.dec[,"I-"], I)

}
\references{
Dary, Stéphane (2011): A New Perspective about Moran’s
Coefficient: Spatial Autocorrelation as a Linear Regression Problem.
Geographical Analysis, 43 (2): pp. 127 - 141.
}
\seealso{
\code{\link{MI.vec}}, \code{\link{MI.ev}}, \code{\link{MI.sf}},
\code{\link{MI.resid}}, \code{\link{getEVs}}
}
\author{
Sebastian Juhl
}
