% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spflow.R
\name{spflow}
\alias{spflow}
\title{Estimate spatial interaction models that incorporate spatial dependence}
\usage{
spflow(
  flow_formula,
  sp_multi_network,
  network_pair_id = id(sp_multi_network)[["network_pairs"]][[1]],
  flow_control = spflow_control()
)
}
\arguments{
\item{flow_formula}{A formula specifying the spatial interaction model (for details see
section Formula interface)}

\item{sp_multi_network}{A \code{\link[=sp_multi_network]{sp_multi_network()}} object that contains information on the origins,
and the destinations and their neighborhood structure}

\item{network_pair_id}{A character indicating the id of a \code{\link[=sp_network_pair]{sp_network_pair()}} (only relevant if
the \code{\link[=sp_multi_network]{sp_multi_network()}} contains multiple \code{sp_network_pair}-objects:
defaults to the of them)}

\item{flow_control}{A list generated by \code{\link[=spflow_control]{spflow_control()}} that provides fine grained control
over the estimation procedure}
}
\value{
An S4 class of type \code{\link[=spflow_model-class]{spflow_model-class()}}
}
\description{
We implement three different estimators of spatial econometric interaction
models \insertCite{Dargel2021}{spflow} that allow the user to estimate
origin-destination flows with spatial autocorrelation.

By default the estimation will include spatial dependence in the dependent
variable and the explanatory variables which leads to the spatial Durbin
model (SDM) \insertCite{Anselin1988}{spflow}.
Moreover, the model includes an additional set of parameters for intra
regional flows that start and end in the same geographic site (as proposed
by \insertCite{LeSage2009;textual}{spflow}).
Both default options can be deactivated via the \code{flow_control} argument,
which gives fine grained control over the estimation.
}
\section{Details}{

Our estimation procedures makes use of the matrix formulation introduced by
\insertCite{LeSage2008;textual}{spflow} and further developed by
\insertCite{Dargel2021;textual}{spflow} to reduce the computational
effort and memory requirements.
The estimation procedure can be adjusted through the \code{estimation_method}
argument in \code{\link[=spflow_control]{spflow_control()}}.
\subsection{Maximum likelihood estimation (MLE)}{

Maximum likelihood estimation is the default estimation procedure.
The matrix form estimation in the framework of this model was first
developed by \insertCite{LeSage2008;textual}{spflow} and then improved by
\insertCite{Dargel2021;textual}{spflow}.
}

\subsection{Spatial two-stage least squares (S2SLS)}{

The S2SLS estimator is an adaptation of the one proposed by
\insertCite{Kelejian1998;textual}{spflow}, to the case of origin-destination
flows, with up to three neighborhood matrices
\insertCite{Dargel2021;textual}{spflow}.
A similar estimation is done by \insertCite{Tamesue2016;textual}{spflow}.
The user can activate the S2SLS estimation via the \code{flow_control} argument
using the input \code{spflow_control(estimation_method = "s2sls")}.
}

\subsection{Bayesian Markov Chain Monte Carlo (MCMC)}{

The MCMC estimator is based on the ideas of
\insertCite{LeSage2009;textual}{spflow} and incorporates the improvements
proposed in \insertCite{Dargel2021;textual}{spflow}.
The estimation is based on a tuned Metropolis-Hastings sampler for the
auto-regressive parameters, and for the remaining parameters it uses Gibbs
sampling.
The routine uses 5500 iterations of the sampling procedure and considers the
first 2500 as burn-in period.
The user can activate the S2SLS estimation via the \code{flow_control} argument
using the input \code{spflow_control(estimation_method = "mcmc")}.
}

\subsection{Formula interface}{

The function offers a formula interface adapted to spatial interaction
models, which has the following structure:
\code{Y ~ O_(X1) + D_(X2) + I_(X3) + G_(X4)}
This structure reflects the different data sources involved in such a model.
On the left hand side there is the independent variable \code{Y} which
corresponds to the vector of flows.
On the right hand side we have all the explanatory variables.
The functions \code{O_(...)} and \code{D_(...)} indicate which variables are used as
characteristics of the origins and destinations respectively.
Similarly, \code{I_(...)} indicates variables that should be used for the
intra-regional parameters.
Finally, \code{G_(...)} declares which variables describe origin-destination
pairs, which most frequently will include a measure of distance.

All the declared variables must be available in the provided
\code{\link[=sp_multi_network]{sp_multi_network()}} object, which gathers information on the origins and
destinations (inside \code{\link[=sp_network_nodes]{sp_network_nodes()}} objects), as well as the
information on the origin-destination pairs (inside a \code{\link[=sp_network_pair]{sp_network_pair()}}
object).

Using the short notation \code{Y ~ .} is possible and will be interpreted as
usual, in the sense that we use all variables that are available for each
data source.
Also mixed formulas, such as \code{Y ~ . + G_(log(X4) + 1)}, are possible.
When the dot shortcut is combined with explicit declaration, it will only be
used for the non declared data sources.
The following examples illustrate this behaviour.
}

\subsection{Formula interface (examples)}{

Consider the case where we have the flow vector \code{Y} and the distance vector
\code{DIST} available as information on origin-destination pairs.
In addition we have  the explanatory variables \verb{X1, X2} and \code{X3} which
describe the regions that are at the same time origins and destinations of
the flows.

For this example the four formulas below are equivalent and make use of all
explanatory variables \verb{X1, X2} and \code{X3} for origins, destinations and
intra-regional observations.
\itemize{
\item \code{Y ~ .}
\item \code{Y ~ . + G_(DIST)}
\item \code{Y ~ X1 + X2 + X3 + G_(DIST)}
\item \code{Y ~ D_(X1 + X2 + X3) + O_(X1 + X2 + X3) + I_(X1 + X2 + X3)  + G_(DIST)}
}

Now if we only want to use X1 for the intra-regional model we can do the
following (again all four options below are equivalent).
\itemize{
\item \code{Y ~ . + I_(X1)}
\item \code{Y ~ . + I_(X1) + G_(DIST)}
\item \code{Y ~  X1 + X2 + X3 + I_(X1) + G_(DIST)}
\item \code{Y ~ D_(X1 + X2 + X3) + O_(X1 + X2 + X3) + I_(X1)  + G_(DIST)}
}

This behaviour is easily combined with transformation of variables as the
two equivalent options below illustrate.
\itemize{
\item \code{log(Y + 1) ~ sqrt(X1) +  X2 + G_(log(DIST + 1))}
}
}
}

\examples{

# Estimate flows between the states of Germany
spflow(flow_formula = y9 ~ . + G_(DISTANCE),
       sp_multi_network = multi_net_usa_ge,
       network_pair_id = "ge_ge")

# Same as above with explicit declaration of variables...
# ... X is the only variable available
# ... it is used for origins, destination and intra-state flows
spflow(flow_formula = y9 ~ X + G_(DISTANCE),
       sp_multi_network = multi_net_usa_ge,
       network_pair_id = "ge_ge")

# Same as above
spflow(flow_formula = y9 ~ O_(.) + D_(.) + I_(.) + G_(DISTANCE),
       sp_multi_network = multi_net_usa_ge,
       network_pair_id = "ge_ge")

# Same as above
spflow(flow_formula = y9 ~ O_(X) + D_(X) + I_(X) + G_(DISTANCE),
       sp_multi_network = multi_net_usa_ge,
       network_pair_id = "ge_ge")


}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=spflow_control]{spflow_control()}} \code{\link[=spflow_network_classes]{spflow_network_classes()}}
}
