% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spflow-control.R
\name{spflow_control}
\alias{spflow_control}
\title{Define details of the estimation procedure with the \code{\link[=spflow]{spflow()}} function.}
\usage{
spflow_control(
  estimation_method = "mle",
  model = "model_9",
  use_intra = TRUE,
  sdm_variables = "same",
  weight_variable = NULL,
  parameter_space = "approx",
  loglik_det_aprox_order = 10,
  mle_hessian_method = "mixed",
  mle_optim_limit = 100,
  twosls_instrumental_variables = "same",
  twosls_decorrelate_instruments = FALSE,
  twosls_reduce_pair_instruments = TRUE,
  mcmc_iterations = 5500,
  mcmc_burn_in = 2500,
  mcmc_resampling_limit = 100
)
}
\arguments{
\item{estimation_method}{A character which indicates the estimation method, should be one of
\code{c("mle","s2sls","mcmc")}}

\item{model}{A character indicating the model number,  indicating different spatial
dependence structures (see documentation for details), should be one of
\code{paste0("model_", 1:9)}}

\item{use_intra}{A logical which activates the option to use a separate set of parameters
for intra-regional flows (origin == destination)}

\item{sdm_variables}{Either a formula or a character; the formula can be used to explicitly
declare the variables in SDM specification, the character should be one of
\code{c("same", "all")} which are short cuts for using all available variables
or the same as used in the main formula provided to \code{\link[=spflow]{spflow()}}}

\item{weight_variable}{A character indicating the name of one column in the node pair data.}

\item{parameter_space}{A character indicating how to define the limits of the parameter space.
The only available option is \code{c("approx")}.}

\item{loglik_det_aprox_order}{A numeric indicating the order of the Taylor expansion used to approximate
the value of the log-determinant term.}

\item{mle_hessian_method}{A character which indicates the method for Hessian calculation}

\item{mle_optim_limit}{A numeric indicating the number of trials given to the optimizer of the
likelihood function. A trial refers to a new initiation of the
optimization procedure using different (random) starting values for the
parameters. If the optimizer does not converge after the
indicated number of trails an error will be thrown after this limit.}

\item{twosls_instrumental_variables}{Either a formula or a character; the formula can be used to explicitly
declare the variables that should be used as instruments during S2SLS
estimation, the character should be one of \code{c("same", "all")} which
are short cuts for using all available variables or the same as used in
the main formula provided to \code{\link[=spflow]{spflow()}}}

\item{twosls_decorrelate_instruments}{A logical whether to perform a PCA to remove (linear) correlation from the
instruments generated for the S2SLS estimator}

\item{twosls_reduce_pair_instruments}{A logical that indicates whether the number of instruments that are
derived from pair attributes should be reduced or not. The default is
\code{TRUE}, because constructing these instruments is often the most demanding
part of the estimation \insertCite{Dargel2021}{spflow}.}

\item{mcmc_iterations}{A numeric indicating the number of iterations}

\item{mcmc_burn_in}{A numeric indicating the length of the burn in period}

\item{mcmc_resampling_limit}{A numeric indicating the maximal number of trials during rejection
sampling of the autoregressive parameters}
}
\value{
A list of parameters used to control the model estimation with
\code{\link[=spflow]{spflow()}}
}
\description{
This function creates a list to fine tune the estimation of a spatial
interaction model with \code{\link[=spflow]{spflow()}}.
The options allow to adjust the estimation method and give the user full
control over the use of the explanatory variables.
The user can also adjust the form of autocorrelation to be considered.
}
\section{Details}{

\subsection{Adjusting the form of autocorrelation}{

The option \code{model} allows to declare one of nine different forms of
autocorrelation that follow the naming convention of
\insertCite{LeSage2008;textual}{spflow}.
The most general specification is "model_9", leading to the model
\eqn{y = \rho_dW_dy + \rho_o W_oy + \rho_wW_wy + Z\delta + \epsilon}.
All other models special cases of this one.
The constraints that lead to the different sub models are summarized in
this table.\tabular{ccc}{
   \strong{Model Number} \tab \strong{Autocorrelation Parameters} \tab \strong{Constraints} \cr
   Model 9 \tab \eqn{\rho_d, \rho_o, \rho_w} \tab unconstrained \cr
   Model 8 \tab \eqn{\rho_d, \rho_o, \rho_w} \tab \eqn{\rho_w = - \rho_d \rho_o} \cr
   Model 7 \tab \eqn{\rho_d, \rho_o} \tab \eqn{\rho_w = 0} \cr
   Model 6 \tab \eqn{\rho_{dow}} \tab \eqn{\rho_d = \rho_o = \rho_w} \cr
   Model 5 \tab \eqn{\rho_{do}} \tab \eqn{\rho_d = \rho_o, \rho_w = 0} \cr
   Model 4 \tab \eqn{\rho_w} \tab \eqn{\rho_d = \rho_o = 0} \cr
   Model 3 \tab \eqn{\rho_o} \tab \eqn{\rho_d = \rho_w = 0} \cr
   Model 2 \tab \eqn{\rho_d} \tab \eqn{\rho_o = \rho_w = 0} \cr
   Model 1 \tab none \tab \eqn{\rho_d = \rho_o = \rho_w = 0} \cr
}

}
}

\examples{

# default is MLE estimation of the most comprehensive model
default_control <- spflow_control()

# change the estimation method
custom_control <- spflow_control(estimation_method = "mcmc")

# change the form of autocorrelation to be considered
custom_control <- spflow_control(model = "model_7")

# declare precisely which variables are to be used in the SDM form
custom_control <-
  spflow_control(sdm_variables = ~ O_(v1 + v2) + D_(v2 + v3) + I_(v1 + v4))

# deactivate the intra-regional coefficients and SDM variables
custom_control <- spflow_control(use_intra = FALSE, sdm_variables = "none")
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=spflow]{spflow()}}
}
