% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impacts.R
\name{impacts.gstsls}
\alias{impacts.gstsls}
\title{Generate impacts for objects of class sarar_gmm created in sphet}
\usage{
\method{impacts}{gstsls}(
  obj,
  ...,
  tr = NULL,
  R = NULL,
  listw = NULL,
  evalues = NULL,
  tol = 1e-06,
  empirical = FALSE,
  Q = NULL,
  KPformula = FALSE,
  prt = TRUE
)
}
\arguments{
\item{obj}{A spreg spatial regression object created by \code{spreg} with model ="sarar"}

\item{...}{Arguments passed through to methods in the \pkg{coda} package}

\item{tr}{A vector of traces of powers of the spatial weights matrix created using \code{trW}, for approximate impact measures; if not given, \code{listw} must be given for exact measures (for small to moderate spatial weights matrices); the traces must be for the same spatial weights as were used in fitting the spatial regression}

\item{R}{If given, simulations are used to compute distributions for the impact measures, returned as \code{mcmc} objects}

\item{listw}{a listw object}

\item{evalues}{vector of eigenvalues of spatial weights matrix for impacts calculations}

\item{tol}{Argument passed to \code{mvrnorm}: tolerance (relative to largest variance) for numerical lack of positive-definiteness in the coefficient covariance matrix}

\item{empirical}{Argument passed to \code{mvrnorm} (default FALSE): if true, the coefficients and their covariance matrix specify the empirical not population mean and covariance matrix}

\item{Q}{default NULL, else an integer number of cumulative power series impacts to calculate if \code{tr} is given}

\item{KPformula}{default FALSE, else inference of the impacts based on Kelejian and Piras (2020)}

\item{prt}{prints the KP summary of the VC matrix}
}
\value{
Estimate of the Average Total, Average Direct, and Average Indirect Effects
}
\description{
Generate impacts for objects of class sarar_gmm created in sphet
}
\examples{
data(boston, package="spData")
Wb <- as(spdep::nb2listw(boston.soi), "CsparseMatrix")
ev <- eigen(Wb)$values
trMatb <- spatialreg::trW(Wb, type="mult")
sarar1 <- spreg(log(CMEDV) ~ CRIM + ZN + INDUS + CHAS + I(NOX^2) + 
                  I(RM^2) +  AGE + log(DIS) + log(RAD) + TAX + PTRATIO + B + log(LSTAT), 
                data = boston.c, listw = Wb, model = "sarar")
summary(sarar1)
impacts(sarar1, KPformula = TRUE)
summary(impacts(sarar1, tr = trMatb, R=1000), zstats=TRUE, short=TRUE)
summary(impacts(sarar1, evalues = ev, R=1000), zstats=TRUE, short=TRUE)

sarar2 <- spreg(log(CMEDV) ~ CRIM + ZN + INDUS + CHAS + I(NOX^2) + 
                  I(RM^2) +  AGE + log(DIS) + log(RAD) + TAX + PTRATIO + B + log(LSTAT), 
                data = boston.c, listw = Wb, model = "sarar", Durbin = TRUE)

summary(sarar2)
impacts(sarar2, evalues = ev, KPformula = TRUE)
impacts(sarar2, evalues = ev)
impacts(sarar2, listw = spdep::nb2listw(boston.soi))
impacts(sarar2, tr = trMatb)
summary(impacts(sarar2, evalues = ev, R=1000), zstats=TRUE, short=TRUE)

sarar3 <- spreg(log(CMEDV) ~ CRIM + ZN + INDUS + CHAS + I(NOX^2) + 
                  I(RM^2) +  AGE + log(DIS) + log(RAD) + TAX + PTRATIO + B + log(LSTAT), 
                data = boston.c, listw = Wb, model = "sarar", Durbin = ~CRIM + TAX)

summary(sarar3)
impacts(sarar3, evalues = ev)
impacts(sarar3, evalues = ev, KPformula = TRUE)
impacts(sarar3, evalues = ev, KPformula = TRUE, tr = trMatb)
impacts(sarar3, listw = spdep::nb2listw(boston.soi))
impacts(sarar3, tr = trMatb)
summary(impacts(sarar3, listw = spdep::nb2listw(boston.soi), R=1000), zstats=TRUE, short=TRUE)

sarar4 <- spreg(log(CMEDV) ~ CRIM + ZN + INDUS + CHAS + I(NOX^2) + 
                  I(RM^2) +  AGE + log(DIS) + log(RAD) + TAX + PTRATIO + B , 
                data = boston.c, listw = Wb, model = "sarar", Durbin = ~CRIM + TAX + log(LSTAT))

summary(sarar4)
impacts(sarar4, evalues = ev)
summary(impacts(sarar4, evalues = ev, R=1000), zstats=TRUE, short=TRUE)

sarar5 <- spreg(log(CMEDV) ~ CRIM + ZN + INDUS + CHAS + I(NOX^2) + I(RM^2) +  AGE + log(DIS), 
                data = boston.c, listw = Wb, model = "sarar", Durbin = ~ TAX + log(LSTAT))

summary(sarar5)
impacts(sarar5, evalues = ev)
summary(impacts(sarar4, tr = trMatb, R=1000), zstats=TRUE, short=TRUE)
}
\references{
Roger Bivand, Gianfranco Piras (2015). Comparing Implementations of Estimation Methods for Spatial Econometrics. \emph{Journal of Statistical Software}, 63(18), 1-36. \url{https://www.jstatsoft.org/v63/i18/}.
Harry Kelejian, Gianfranco Piras (2020). Spillover effects in spatial models: Generalization and extensions. \emph{Journal of Regional Science}, 60(3), 425-442. \url{https://onlinelibrary.wiley.com/doi/10.1111/jors.12476}
}
