% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crawl-delay.r
\name{crawl_delays}
\alias{crawl_delays}
\title{Retrieve all agent crawl delay values in a \code{robxp} \code{robots.txt} object}
\usage{
crawl_delays(obj)
}
\arguments{
\item{obj}{\code{robxp} object}
}
\value{
data frame of agents and their crawl delays
}
\description{
Retrieve all agent crawl delay values in a \code{robxp} \code{robots.txt} object
}
\note{
\code{-1} will be returned for any listed agent \emph{without} a crawl delay setting
}
\examples{
gh <- paste0(readLines(system.file("extdata", "github-robots.txt",
             package="spiderbar")), collapse="\n")
gh_rt <- robxp(gh)
crawl_delays(gh_rt)

imdb <- paste0(readLines(system.file("extdata", "imdb-robots.txt",
               package="spiderbar")), collapse="\n")
imdb_rt <- robxp(imdb)
crawl_delays(imdb_rt)
}
