% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/9_data.r
\docType{data}
\name{BreastCancer}
\alias{BreastCancer}
\title{Wisconsin Breast Cancer Database}
\format{
Data frame with 675 observations of 11 variables: factor Id,
9 numeric variables, and target factor Class.
}
\usage{
BreastCancer
}
\description{
Formatted subset of \verb{mlbench's} \code{BreastCancer} (not explicitly exported).
See \code{help(BreastCancer, package = "mlbench")} for the original documentation.
}
\details{
The objective is to identify each of a number of benign or malignant classes.
Samples arrive periodically as Dr. Wolberg reports his clinical cases. The
database therefore reflects this chronological grouping of the data. This
grouping information appears immediately below, having been removed from
the data itself. Each variable except for the first was converted into 11
primitive numerical attributes with values ranging from 0 through 10. Rows
with missing attribute values and duplicate rows removed.

Data frame with 675 observations of 11 variables: factor Id,
9 numeric variables, and target factor Class.
\itemize{
\item Id, Sample code number
\item Cl.thickness, Clump thickness
\item Cell.size, Uniformity of cell size
\item Cell.shape, Uniformity of cell shape
\item Marg.adhesion, Marginal adhesion
\item Epith.c.size, Single Epthelial cell size
\item Bare.nuclei, Bare nuclei
\item Bl.cromatin, Bland chromatin
\item Normal.nucleoli, Normal Nucleoli
\item Mitoses, Mitoses
\item Class, Class of cancer, either "benign" or "malignant"
}

Reproducing this dataset:\preformatted{require("mlbench")
data(BreastCancer)

d <- BreastCancer
d <- d[!duplicated(d), ] ## Remove 8 duplicate rows
d <- d[complete.cases(d), ] ## Remove 16 row-wise incomplete rows
mat <- as.matrix(d[ , 2:10])
mat <- apply(mat, 2, as.numeric)
BreastCancer <- 
  data.frame(Id = as.factor(d$Id), mat, Class = as.factor(d$Class))
## save(BreastCancer, file = "./data/BreastCancer.rda")
}
}
\examples{
str(BreastCancer)
\dontrun{
dat <- scale_sd(BreastCancer[, 2:10])
clas <- BreastCancer$Class
bas <- prcomp(dat)$rotation[, 1:2]
mvar <- which(abs(bas[, 1]) == max(abs(bas[, 1])))

play_manual_tour(basis = bas, data = dat, manip_var = mvar,
                 render_type = render_gganimate, color = clas, shape = clas)
}
}
\keyword{datasets}
