% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_ggproto_visualize.r
\name{append_fixed_y}
\alias{append_fixed_y}
\title{Append a fixed vertical height}
\usage{
append_fixed_y(fixed_y)
}
\arguments{
\item{fixed_y}{Vector of length of the data, values to fix vertical height.
Typically related to but not an explanatory variable, for instance,
predicted Y, or residuals.}
}
\description{
Adds/overwrites the y of the projected data. Usefully for 1D projections and
appending information related to, but independent from the projection;
model predictions or residuals for instance.
Wants to be called early so that the following proto calls adopt the changes.
}
\examples{
library(spinifex)
dat     <- scale_sd(penguins_na.rm[, 1:4])
clas    <- penguins_na.rm$species
bas     <- basis_pca(dat)
mv      <- manip_var_of(bas)
mt_path <- manual_tour(bas, manip_var = mv)

# Fixed y height with related information, independent of a 1D tour 
# _eg_ predictions or residuals.
message("don't forget to scale your fixed_y.")
dummy_y <- scale_sd(as.integer(clas) + rnorm(nrow(dat), 0, .5))
gt_path <- save_history(dat, grand_tour(d = 1), max_bases = 5)

message("append_fixed_y wants to be called early so other proto's adopt the fixed_y.")
ggt <- ggtour(gt_path, dat, angle = .3) +
  append_fixed_y(fixed_y = dummy_y) + ## insert/overwrites vertical values.
  proto_point(list(fill = clas, color = clas)) +
  proto_basis1d() +
  proto_origin()
\donttest{
animate_plotly(ggt)
}
}
\seealso{
Other ggtour proto functions: 
\code{\link{facet_wrap_tour}()},
\code{\link{ggtour}()},
\code{\link{proto_basis}()},
\code{\link{proto_default}()},
\code{\link{proto_density}()},
\code{\link{proto_density2d}()},
\code{\link{proto_hex}()},
\code{\link{proto_highlight}()},
\code{\link{proto_hline0}()},
\code{\link{proto_origin}()},
\code{\link{proto_point}()},
\code{\link{proto_text}()}
}
\concept{ggtour proto functions}
