% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_ggproto_visualize.r
\name{proto_default}
\alias{proto_default}
\alias{proto_default2d}
\alias{proto_def}
\alias{proto_def2d}
\alias{proto_default1d}
\alias{proto_def1d}
\title{Wrapper function for default 2D/1D tours respectively.}
\usage{
proto_default(
  position = c("left", "center", "right", "bottomleft", "topright", "off"),
  ...
)

proto_default1d(position = c("bottom1d", "floor1d", "top1d", "off"), ...)
}
\arguments{
\item{position}{The position, to place the basis axes relative to the
data. \code{proto_basis} expects one of c("left", "center", "right", "bottomleft", "topright",
"off"), defaults to "left". \code{proto_basis1d} expects one of
c("bottom1d", "floor1d", "top1d", "off"). Defaults to "bottom1d".}

\item{...}{Optionally pass additional arguments to \code{proto_point} or
\code{proto_density}.}
}
\description{
An easier way to get to default 2D tour settings.
Returns a list of proto_origin(), proto_point(...), proto_basis() for 2D.
Returns a list of proto_origin1d(), proto_density(...), proto_basis1d() for 1D.
}
\examples{
library(spinifex)
dat  <- scale_sd(penguins_na.rm[, 1:4])
clas <- penguins_na.rm$species

## 2D case:
bas     <- basis_pca(dat)
mv      <- manip_var_of(bas)
mt_path <- manual_tour(bas, mv)

ggt <- ggtour(mt_path, dat) +
  proto_default(aes_args = list(color = clas, shape = clas))
\donttest{
animate_plotly(ggt)
}
library(spinifex)

## 1D case:
gt_path <- save_history(dat, grand_tour(d = 1), max_bases = 3)

ggt <- ggtour(gt_path, dat) +
  proto_default1d(aes_args = list(fill = clas, color = clas))
\donttest{
animate_plotly(ggt)
}
}
\seealso{
Other ggtour proto functions: 
\code{\link{append_fixed_y}()},
\code{\link{facet_wrap_tour}()},
\code{\link{ggtour}()},
\code{\link{proto_basis}()},
\code{\link{proto_density}()},
\code{\link{proto_density2d}()},
\code{\link{proto_hex}()},
\code{\link{proto_highlight}()},
\code{\link{proto_hline0}()},
\code{\link{proto_origin}()},
\code{\link{proto_point}()},
\code{\link{proto_text}()}
}
\concept{ggtour proto functions}
