% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evap.R
\name{elv2pres}
\alias{elv2pres}
\title{Elevation to pressure}
\usage{
elv2pres(
  z,
  kG = 9.80665,
  kL = 0.0065,
  kMa = 0.028963,
  kPo = 101325,
  kR = 8.31447,
  kTo = 288.15
)
}
\arguments{
\item{z}{Elevation, m.}

\item{kG}{Gravitational acceleration, m/s^2.
Default: \eqn{9.80665} (Allen, 1973)}

\item{kL}{Adiabatic lapse rate, K/m.
Default: \eqn{0.0065} (Allen, 1973)}

\item{kMa}{Molecular weight of dry air, kg/mol.
Default: \eqn{0.028963} (Tsilingiris, 2008)}

\item{kPo}{Standard atmosphere, Pa.
Default: \eqn{101325} (Allen, 1973)}

\item{kR}{Universal gas constant, J/mol/K.
Default: \eqn{8.31447} (Moldover et al., 1988)}

\item{kTo}{Base temperature, K.
Default: \eqn{288.15} (Berberan-Santos et al., 1997)}
}
\value{
Atmospheric pressure for the given elevation, Pa.
}
\description{
Calculates atmospheric pressure for a given elevation.
}
\references{
Allen, R.G., Pereira, L.S., Raes, D. and Smith, M., 1998. Crop
evapotranspiration-Guidelines for computing crop water requirements-FAO
Irrigation and drainage paper 56. Food and Agriculture Organization of the
United Nations, Rome, 300(9), p.D05109. Available:
http://www.fao.org/docrep/x0490e/x0490e07.htm

Berberan-Santos, M.N., Bodunov, E.N. and Pogliani, L., 1997. On the
barometric formula. American Journal of Physics, 65(5), pp.404-412.
doi:10.1119/1.18555

Moldover, M.R., Trusler, J.M., Edwards, T.J., Mehl, J.B. and Davis, R.S.,
1988. Measurement of the universal gas constant R using a spherical acoustic
resonator. Physical review letters, 60(4), p.249.
doi:10.1103/PhysRevLett.60.249

Tsilingiris, P.T., 2008. Thermophysical and transport properties of humid air
at temperature range between 0 and 100 C. Energy Conversion and Management,
49(5), pp.1098-1110. doi:10.1016/j.enconman.2007.09.015
}
\keyword{internal}
