% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evap.R
\name{psychro}
\alias{psychro}
\title{Calculate psychrometric constant}
\usage{
psychro(tc, pa, kMa = 0.028963, kMv = 0.01802)
}
\arguments{
\item{tc}{double, air temperature, degrees C.}

\item{pa}{double, atm pressure, Pa.}

\item{kMa}{double, molecular weight of dry air, kg/mol.
Default: \eqn{0.028963} (Tsilingiris, 2008)}

\item{kMv}{double, molecular weight of water vapor, kg/mol.
Default: \eqn{0.01802} (Tsilingiris, 2008)}
}
\value{
double, Pa/K.
}
\description{
This function calculates the temperature and pressure dependent
psychrometric constant.
}
\references{
Allen, R.G., Pereira, L.S., Raes, D. and Smith, M., 1998. Crop
evapotranspiration-Guidelines for computing crop water requirements-FAO
Irrigation and drainage paper 56. Food and Agriculture Organization of the
United Nations, Rome, 300(9), p.D05109. Available:
http://www.fao.org/docrep/x0490e/x0490e07.htm
}
\keyword{internal}
